/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.lz;

import java.io.IOException;
import java.io.OutputStream;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.lz.BT4;
import org.tukaani.xz.lz.HC4;
import org.tukaani.xz.lz.Matches;

public abstract class LZEncoder {
    public static final int MF_HC4 = 4;
    public static final int MF_BT4 = 20;
    private final int keepSizeBefore;
    private final int keepSizeAfter;
    final int matchLenMax;
    final int niceLen;
    final byte[] buf;
    final int bufSize;
    int readPos = -1;
    private int readLimit = -1;
    private boolean finishing = false;
    private int writePos = 0;
    private int pendingSize = 0;

    static void normalize(int[] is, int i, int j) {
        for (int k = 0; k < i; ++k) {
            if (is[k] <= j) {
                is[k] = 0;
                continue;
            }
            int n = k;
            is[n] = is[n] - j;
        }
    }

    private static int getBufSize(int i, int j, int k, int l) {
        int n = j + i;
        int n2 = k + l;
        int n3 = Math.min(i / 2 + 262144, 0x20000000);
        return n + n2 + n3;
    }

    public static int getMemoryUsage(int i, int j, int k, int l, int m) {
        int n = LZEncoder.getBufSize(i, j, k, l) / 1024 + 10;
        switch (m) {
            case 4: {
                n += HC4.getMemoryUsage(i);
                break;
            }
            case 20: {
                n += BT4.getMemoryUsage(i);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return n;
    }

    public static LZEncoder getInstance(int i, int j, int k, int l, int m, int n, int o, ArrayCache arrayCache) {
        switch (n) {
            case 4: {
                return new HC4(i, j, k, l, m, o, arrayCache);
            }
            case 20: {
                return new BT4(i, j, k, l, m, o, arrayCache);
            }
        }
        throw new IllegalArgumentException();
    }

    LZEncoder(int i, int j, int k, int l, int m, ArrayCache arrayCache) {
        this.bufSize = LZEncoder.getBufSize(i, j, k, m);
        this.buf = arrayCache.getByteArray(this.bufSize, false);
        this.keepSizeBefore = j + i;
        this.keepSizeAfter = k + m;
        this.matchLenMax = m;
        this.niceLen = l;
    }

    public void putArraysToCache(ArrayCache arrayCache) {
        arrayCache.putArray(this.buf);
    }

    public void setPresetDict(int i, byte[] bs) {
        assert (!this.isStarted());
        assert (this.writePos == 0);
        if (bs != null) {
            int n = Math.min(bs.length, i);
            int n2 = bs.length - n;
            System.arraycopy(bs, n2, this.buf, 0, n);
            this.writePos += n;
            this.skip(n);
        }
    }

    private void moveWindow() {
        int n = this.readPos + 1 - this.keepSizeBefore & 0xFFFFFFF0;
        int n2 = this.writePos - n;
        System.arraycopy(this.buf, n, this.buf, 0, n2);
        this.readPos -= n;
        this.readLimit -= n;
        this.writePos -= n;
    }

    public int fillWindow(byte[] bs, int i, int j) {
        assert (!this.finishing);
        if (this.readPos >= this.bufSize - this.keepSizeAfter) {
            this.moveWindow();
        }
        if (j > this.bufSize - this.writePos) {
            j = this.bufSize - this.writePos;
        }
        System.arraycopy(bs, i, this.buf, this.writePos, j);
        this.writePos += j;
        if (this.writePos >= this.keepSizeAfter) {
            this.readLimit = this.writePos - this.keepSizeAfter;
        }
        this.processPendingBytes();
        return j;
    }

    private void processPendingBytes() {
        if (this.pendingSize > 0 && this.readPos < this.readLimit) {
            this.readPos -= this.pendingSize;
            int n = this.pendingSize;
            this.pendingSize = 0;
            this.skip(n);
            assert (this.pendingSize < n);
        }
    }

    public boolean isStarted() {
        return this.readPos != -1;
    }

    public void setFlushing() {
        this.readLimit = this.writePos - 1;
        this.processPendingBytes();
    }

    public void setFinishing() {
        this.readLimit = this.writePos - 1;
        this.finishing = true;
        this.processPendingBytes();
    }

    public boolean hasEnoughData(int i) {
        return this.readPos - i < this.readLimit;
    }

    public void copyUncompressed(OutputStream outputStream, int i, int j) throws IOException {
        outputStream.write(this.buf, this.readPos + 1 - i, j);
    }

    public int getAvail() {
        assert (this.isStarted());
        return this.writePos - this.readPos;
    }

    public int getPos() {
        return this.readPos;
    }

    public int getByte(int i) {
        return this.buf[this.readPos - i] & 0xFF;
    }

    public int getByte(int i, int j) {
        return this.buf[this.readPos + i - j] & 0xFF;
    }

    public int getMatchLen(int i, int j) {
        int n;
        int n2 = this.readPos - i - 1;
        for (n = 0; n < j && this.buf[this.readPos + n] == this.buf[n2 + n]; ++n) {
        }
        return n;
    }

    public int getMatchLen(int i, int j, int k) {
        int n;
        int n2 = this.readPos + i;
        int n3 = n2 - j - 1;
        for (n = 0; n < k && this.buf[n2 + n] == this.buf[n3 + n]; ++n) {
        }
        return n;
    }

    public boolean verifyMatches(Matches matches) {
        int n = Math.min(this.getAvail(), this.matchLenMax);
        for (int i = 0; i < matches.count; ++i) {
            if (this.getMatchLen(matches.dist[i], n) == matches.len[i]) continue;
            return false;
        }
        return true;
    }

    int movePos(int i, int j) {
        assert (i >= j);
        ++this.readPos;
        int n = this.writePos - this.readPos;
        if (!(n >= i || n >= j && this.finishing)) {
            ++this.pendingSize;
            n = 0;
        }
        return n;
    }

    public abstract Matches getMatches();

    public abstract void skip(int var1);
}

