import { createMiddleware } from "@tanstack/react-start";

export const requireSession = createMiddleware().server(
	async ({ next, request }) => {
		const headers = request.headers;
		const sessionToken = headers.get("x-session-token");

		if (!sessionToken) {
			throw new Response("Unauthorized", { status: 401 });
		}

		// hardcoded token check for demonstration purposes
		if (sessionToken !== "valid-token") {
			throw new Response("Forbidden", { status: 403 });
		}

		return next();
	},
);

export const requireAdminSessioon = createMiddleware().server(
	async ({ next, request }) => {
		const headers = request.headers;
		const sessionToken = headers.get("x-session-token");

		if (!sessionToken) {
			throw new Response("Unauthorized", { status: 401 });
		}

		// hardcoded token check for demonstration purposes
		if (sessionToken !== "valid-admin-token") {
			throw new Response("Forbidden", { status: 403 });
		}

		return next();
	},
);
