package be.ucll.unit.service;

import be.ucll.model.Publication;
import be.ucll.repository.PublicationRepository;
import be.ucll.service.PublicationService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import java.util.List;

import static org.junit.jupiter.api.Assertions.assertEquals;

public class PublicationServiceTest {

    private PublicationService publicationService;

    @BeforeEach
    public void setUp() {
        PublicationRepository publicationRepository = new PublicationRepository();
        publicationService = new PublicationService(publicationRepository);
    }

    @Test
    public void testFindPublicationsByTitleAndTypeWithNoParametersGiven() {
        List<Publication> publications = publicationService.findPublicationByTitleAndType(null, null);
        assertEquals(6, publications.size());
    }

    @Test
    public void testFindPublicationsByTitleAndTypeWithEmptyParametersGiven() {
        List<Publication> publications = publicationService.findPublicationByTitleAndType("","");
        assertEquals(0, publications.size());
    }

    @Test
    public void testFindPublicationsByTitleAndTypeWithCorrectTitleAndNoTypeGiven() {
        List<Publication> publications = publicationService.findPublicationByTitleAndType("De zilverboom", null);
        assertEquals(1, publications.size());
    }

    @Test
    public void testFindPublicationsByTitleAndTypeWithCorrectPartOfTitleAndNoTypeGiven() {
        List<Publication> publications = publicationService.findPublicationByTitleAndType("zilver", null);
        assertEquals(1, publications.size());
    }

    @Test
    public void testFindPublicationsByTitleAndTypeWithCorrectPartOfTitleThatAppliesToMoreThenOneItemAndNoTypeGiven() {
        List<Publication> publications = publicationService.findPublicationByTitleAndType("il", null);
        assertEquals(2, publications.size());
    }

    @Test
    public void testFindPublicationsByTitleAndTypeWithIncorrectTitleAndNoTypeGiven() {
        List<Publication> publications = publicationService.findPublicationByTitleAndType("The wolf of wallstreet", null);
        assertEquals(0, publications.size());
    }

    @Test
    public void testFindPublicationsByTitleAndTypeWithTypeBookAndNoTitleGiven() {
        List<Publication> publications = publicationService.findPublicationByTitleAndType(null, "book");
        assertEquals(3, publications.size());
    }

    @Test
    public void testFindPublicationsByTitleAndTypeWithTypeMagazineAndNoTitleGiven() {
        List<Publication> publications = publicationService.findPublicationByTitleAndType(null, "magazine");
        assertEquals(3, publications.size());
    }

    @Test
    public void testFindPublicationsByTitleAndTypeWithIncorrectTypeAndNoTitleGiven() {
        List<Publication> publications = publicationService.findPublicationByTitleAndType(null, "cd");
        assertEquals(0, publications.size());
    }

    @Test
    public void testFindPublicationsByTitleAndTypeWithCorrectTitleAndTypeGiven() {
        List<Publication> publications = publicationService.findPublicationByTitleAndType("National Geographic", "magazine");
        assertEquals(1, publications.size());
    }

    @Test
    public void testFindPublicationsByTitleAndTypeWithCorrectTitleAndIncorrectTypeGiven() {
        List<Publication> publications = publicationService.findPublicationByTitleAndType("National Geographic", "book");
        assertEquals(0, publications.size());
    }

    @Test
    public void testFindPublicationsByTitleAndTypeWithIncorrectTitleAndCorrectTypeGiven() {
        List<Publication> publications = publicationService.findPublicationByTitleAndType("1984", "magazine");
        assertEquals(0, publications.size());
    }

    @Test
    public void testFindPublicationsByTitleAndTypeWithIncorrectTitleAndIncorrectTypeGiven() {
        List<Publication> publications = publicationService.findPublicationByTitleAndType("2026", "cd");
        assertEquals(0, publications.size());
    }
    @Test
    public void testFindPublicationsByAvailableCopies() {
        List<Publication> publications = publicationService.findPublicationsByAvailableCopies(5);
        assertEquals(4, publications.size());
    }

    @Test
    public void testFindPublicationsByAvailableCopiesNoMatch() {
        List<Publication> publications = publicationService.findPublicationsByAvailableCopies(20);
        assertEquals(0, publications.size());
    }
}
