package be.ucll.unit.service;

import be.ucll.model.Loan;
import be.ucll.repository.DbInitializer;
import be.ucll.repository.LoanRepository;
import be.ucll.repository.UserRepository;
import be.ucll.service.LoanService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import java.util.List;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertThrows;

public class LoanServiceTest {

    private LoanService loanService;
    private UserRepository userRepository;
    private LoanRepository loanRepository;

    private DbInitializer dbinitializer;

    @BeforeEach
    public void setUp() {
//        LoanRepository loanRepository = new LoanRepository();
        dbinitializer.initialize();
//        userRepository = new UserRepository();
        loanService = new LoanService(loanRepository, userRepository);
    }

    @Test
    public void testGetLoansByUser() {
        List<Loan> loans = loanService.getLoansByUser("john.doe@ucll.be", false);
        assertEquals(1, loans.size()); // Adjust based on test data
    }

    @Test
    public void testGetLoansByUserOnlyActive() {
        List<Loan> loans = loanService.getLoansByUser("john.doe@ucll.be", true);
        assertEquals(0, loans.size()); // Adjust based on test data
    }

    @Test
    public void testGetLoansByUserUserNotFound() {
        Exception exception = assertThrows(RuntimeException.class, () -> {
            loanService.getLoansByUser("nonexistent@ucll.be", false);
        });
        assertEquals("User with email nonexistent@ucll.be does not exist.", exception.getMessage());
    }

    @Test
    public void testDeleteUserLoans() {
        String string = loanService.removeUserLoans("john.doe@ucll.be");

        assertEquals("Loans of user successfully deleted.", string);
    }

    @Test
    public void testDeleteUserLoansWhenUserHasActiveLoans() {
        Exception exception = assertThrows(RuntimeException.class, () -> {
            String string = loanService.removeUserLoans("jane.toe@ucll.be");
        });

        assertEquals("User has active loans.", exception.getMessage());
    }

    @Test
    public void testDeleteUserLoansWhenUserHasNoLoans() {
        Exception exception = assertThrows(RuntimeException.class, () -> {
            String string = loanService.removeUserLoans("birgit.doe@ucll.be");
        });

        assertEquals("User has no loans.", exception.getMessage());
    }

    @Test
    public void testDeleteUserLoansWhenGivenEmailAddressDoesNotExist() {
        Exception exception = assertThrows(RuntimeException.class, () -> {
            String string = loanService.removeUserLoans("nonexistent@ucll.be");
        });

        assertEquals("User does not exist.", exception.getMessage());
    }
}