package be.ucll.integration;

import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.reactive.AutoConfigureWebTestClient;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.web.reactive.server.WebTestClient;

@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
@AutoConfigureWebTestClient
public class PublicationIntegrationTest {

    @Autowired
    private WebTestClient webTestClient;

    @Test
    public void givenPublications_whenGetByTitleAndType_thenPublicationsAreReturned() {
        webTestClient
                .get()
                .uri(uriBuilder -> uriBuilder
                        .path("/publications")
                        .queryParam("title", "To Kill a Mockingbird")
                        .queryParam("type", "book")
                        .build())
                .exchange()
                .expectStatus().isOk()
                .expectBody()
                .json("[\n" +
                        "    {\n" +
                        "        \"title\": \"To Kill a Mockingbird\",\n" +
                        "        \"publicationYear\": 2020,\n" +
                        "        \"availableCopies\": 6\n" +
                        "    }\n" +
                        "]");
    }

    @Test
    public void givenPublications_whenGetByAvailableCopies_thenPublicationsAreReturned() {
        webTestClient
                .get()
                .uri("/publications/stock/5")
                .exchange()
                .expectStatus().isOk()
                .expectBody()
                .json("[\n" +
                        "    {\n" +
                        "        \"title\": \"To Kill a Mockingbird\",\n" +
                        "        \"author\": \"Harper Lee\",\n" +
                        "        \"publicationYear\": 2020,\n" +
                        "        \"availableCopies\": 6,\n" +
                        "        \"isbn\": \"9789401613072\"\n" +
                        "    },\n" +
                        "    {\n" +
                        "        \"title\": \"National Geographic\",\n" +
                        "        \"editor\": \"Susan Goldberg\",\n" +
                        "        \"publicationYear\": 2023,\n" +
                        "        \"availableCopies\": 10,\n" +
                        "        \"issn\": \"0027-9358\"\n" +
                        "    },\n" +
                        "    {\n" +
                        "        \"title\": \"Time\",\n" +
                        "        \"editor\": \"Edward Felsenthal\",\n" +
                        "        \"publicationYear\": 2024,\n" +
                        "        \"availableCopies\": 15,\n" +
                        "        \"issn\": \"0040-781X\"\n" +
                        "    },\n" +
                        "    {\n" +
                        "        \"title\": \"The Economist\",\n" +
                        "        \"editor\": \"Zanny Minton Beddoes\",\n" +
                        "        \"publicationYear\": 2024,\n" +
                        "        \"availableCopies\": 8,\n" +
                        "        \"issn\": \"0013-0613\"\n" +
                        "    }\n" +
                        "]");
    }
}