package be.ucll.service;

import be.ucll.model.User;
import be.ucll.repository.LoanRepository;
import be.ucll.repository.UserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class UserService {
    private final UserRepository userRepository;
    private final LoanRepository loanRepository;

    @Autowired
    public UserService(UserRepository userRepository, LoanRepository loanRepository) {
        this.userRepository = userRepository;
        this.loanRepository = loanRepository;
    }

    public List<User> getAllUsers() {
        return userRepository.findAll();
    }

    public List<User> getAllAdultUsers() {
        return userRepository.findByAgeGreaterThan(18);
    }

    public List<User> getUsersWithinAgeRange(int min, int max) {
        if (min > max) {
            throw new RuntimeException("Minimum age cannot be greater than maximum age.");
        }
        if (min < 0 || max > 150) {
            throw new RuntimeException("Invalid age range. Age must be between 0 and 150.");
        }
        return userRepository.findByAgeBetween(min, max);
    }

    public List<User> getUserByName(String name) {
        if (userRepository.findByName(name).isEmpty()) {
            throw new RuntimeException("No users found with the specified name.");
        }
        return userRepository.findByName(name);
    }

    public User addUser(User user) {
        if (userRepository.existsByEmailIgnoreCase(user.getEmail())) {
            throw new RuntimeException("User already exists.");
        }
        return userRepository.save(user);
    }

    public User updateUser(String email, User newInformation) {
        if (!userRepository.existsByEmailIgnoreCase(email)) {
            throw new RuntimeException("User does not exist.");
        }

        User user = userRepository.findByEmailIgnoreCase(email);
        user.updateNameAndAgeAndPassword(
                newInformation.getName(),
                newInformation.getAge(),
                newInformation.getEmail(),
                newInformation.getPassword());
        return user;
    }
    public String deleteUser(String email) {
        if (!userRepository.existsByEmailIgnoreCase(email)) {
            throw new RuntimeException("User does not exist.");
        }


        if (!loanRepository.findAllByUserEmailAndEndDateIsNull(email).isEmpty()) {
            throw new RuntimeException("User has active loans.");
        }
        loanRepository.deleteAllByUserEmail(email); // Remove inactive loans

        User user = userRepository.findByEmailIgnoreCase(email);
        userRepository.delete(user); // Delete user

        return "User successfully deleted.";
    }
}