package be.ucll.service;

import be.ucll.model.Book;
import be.ucll.model.Magazine;
import be.ucll.model.Publication;
import be.ucll.repository.PublicationRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service
public class  PublicationService {
    private final PublicationRepository publicationRepository;

    @Autowired
    public PublicationService(PublicationRepository publicationRepository) {
        this.publicationRepository = publicationRepository;
    }

   public List<Publication> getAllPublications() {
       return publicationRepository.allPublications();
    }
    public List<Publication> findPublicationsByAvailableCopies(int availableCopies) {
        return publicationRepository.findPublicationsByAvailableCopies(availableCopies);
    }

    public List<Publication> findPublicationByTitleAndType(String title, String type) {
        return publicationRepository.allPublications().stream()
                .filter(publication -> (title == null || publication.getTitle().toLowerCase().contains(title.toLowerCase())))
                .filter(publication -> (type == null ||
                        (publication instanceof Book && type.equalsIgnoreCase("book")) ||
                        (publication instanceof Magazine && type.equalsIgnoreCase("magazine"))))
                .collect(Collectors.toList());
    }
}
