package be.ucll.service;

import be.ucll.model.Loan;
import be.ucll.repository.LoanRepository;
import be.ucll.repository.UserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

@Service
public class LoanService {
    private final LoanRepository loanRepository;
    private final UserRepository userRepository;

    @Autowired
    public LoanService(LoanRepository loanRepository, UserRepository userRepository) {
        this.loanRepository = loanRepository;
        this.userRepository = userRepository;
    }

//    public List<Loan> getLoansByUser(String email, boolean onlyActive) {
//        if (!userRepository.existsByEmailIgnoreCase(email)) {
//            throw new RuntimeException("User with email " + email + " does not exist.");
//        }
//
//        if (onlyActive) {
//            for (Loan loan : loanRepository.findAllByUserEmail(email)) {
//                if (loan.getEndDate().isAfter(LocalDate.now())) {
//                    return List.of(loan);
//                }
//            }
//        }
//        return loanRepository.findAllByUserEmail(email);
//
//    }
// Find active loans (endDate is null) by user email
public List<Loan> getLoansByUser(String email, boolean onlyActive) {
    if (!userRepository.existsByEmailIgnoreCase(email)) {
        throw new RuntimeException("User with email " + email + " does not exist.");
    }

    // Return active loans if onlyActive is true, otherwise return all loans
    return onlyActive
            ? loanRepository.findAllByUserEmailAndEndDateIsNull(email)
            : loanRepository.findAllByUserEmail(email);
}

    public String removeUserLoans(String email) {
        if (!userRepository.existsByEmailIgnoreCase(email)) {
            throw new RuntimeException("User does not exist.");
        }

        // if the user has active loans, throw error: "user has active loans"
        if (!loanRepository.findAllByUserEmail(email).isEmpty()) {
            throw new RuntimeException("User has active loans.");
        }

        // if the user has no loans, throw error: "user has no loans"
        if (loanRepository.findAllByUserEmail(email).isEmpty()) {
            throw new RuntimeException("User has no loans.");
        }

        loanRepository.deleteAllByUserEmail(email);
        return "Loans of user successfully deleted.";
    }
}
