package be.ucll.repository;

import be.ucll.model.User;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Repository
public interface UserRepository extends JpaRepository<User, Long> {

    List<User> findByAgeGreaterThan(Integer age);

    List<User> findByAgeBetween(int min, int max);

    List<User> findByName(String name);

    User findByEmailIgnoreCase(String email);

    boolean existsByEmailIgnoreCase(String email);
}