package be.ucll.repository;

import be.ucll.model.Book;
import be.ucll.model.Magazine;
import be.ucll.model.Publication;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;


@Repository
public class PublicationRepository {
    public List<Book> books;
    public List<Magazine> magazines;

    public PublicationRepository() {
        books = new ArrayList<>(List.of(
                new Book("De zilverboom", "Lucinda Riley", "9789401613071", 2021, 4),
                new Book("To Kill a Mockingbird", "Harper Lee", "9789401613072", 2020, 6),
                new Book("1984", "George Orwell", "9789401613073", 1949, 2)
        ));
        magazines = new ArrayList<>(List.of(
                    new Magazine("National Geographic", "Susan Goldberg", "0027-9358", 2023, 10),
                    new Magazine("Time", "Edward Felsenthal", "0040-781X", 2024, 15),
                    new Magazine("The Economist", "Zanny Minton Beddoes", "0013-0613", 2024, 8)
        ));
    }

    public List<Publication> allPublications() {
        List<Publication> publications = new ArrayList<>();
        publications.addAll(books);
        publications.addAll(magazines);
        return publications;
    }

    public List<Book> allBooks() {
        return books;
    }

    public List<Magazine> allMagazines() {
        return magazines;
    }

    public List<Publication> findPublicationsByAvailableCopies(int availableCopies) {
        return allPublications().stream()
                .filter(publication -> publication.getAvailableCopies() >= availableCopies)
                .collect(Collectors.toList());
    }
    public List<Publication> findPublicationsByTitleAndType(String title, String type) {
        return allPublications().stream()
                .filter(publication -> (title == null || publication.getTitle().toLowerCase().contains(title.toLowerCase())))
                .filter(publication -> (type == null ||
                        (publication instanceof Book && type.equalsIgnoreCase("book")) ||
                        (publication instanceof Magazine && type.equalsIgnoreCase("magazine"))))
                .collect(Collectors.toList());
    }
}
