package be.ucll.repository;

import be.ucll.model.Loan;
import org.springframework.stereotype.Repository;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Repository
public class LoanRepositoryList {
    private List<Loan> loans;

    public LoanRepositoryList() {
        loans = new ArrayList<>(List.of(
                new Loan("john.doe@ucll.be", "Effective Java", LocalDate.now().minusDays(10), LocalDate.now().minusDays(2)),
                new Loan("jane.toe@ucll.be", "Clean Code", LocalDate.now().minusDays(15), LocalDate.now().minusDays(4)),
                new Loan("jane.toe@ucll.be", "Clean Code Part 2", LocalDate.now().minusDays(4), null)
        ));
    }

    public List<Loan> findLoansByUser(String email, boolean onlyActive) {
        return loans.stream()
                .filter(loan -> loan.getUserEmail().equalsIgnoreCase(email))
                .filter(loan -> !onlyActive || loan.getEndDate() == null)
                .collect(Collectors.toList());
    }

    public void deleteLoansByUser(String email) {
        loans.removeIf(loan -> loan.getUserEmail().equalsIgnoreCase(email));
    }
}