package be.ucll.repository;

import be.ucll.model.Loan;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface LoanRepository extends JpaRepository<Loan, Long> {

    List<Loan> findAllByUserEmail(String email);

    List<Loan> findAllByUserEmailAndEndDateIsNull(String email);

    void deleteAllByUserEmail(String email);
}