package be.ucll.repository;

import be.ucll.model.Loan;
import be.ucll.model.User;
import jakarta.annotation.PostConstruct;
import org.springframework.stereotype.Component;

import java.time.LocalDate;

@Component
public class DbInitializer {
    private final UserRepository userRepository;
    private final LoanRepository loanRepository;

    public DbInitializer(UserRepository userRepository, LoanRepository loanRepository) {
        this.userRepository = userRepository;
        this.loanRepository = loanRepository;
    }

    @PostConstruct
    public void initialize() {
        User user = new User("John Doe", 25, "john.doe@ucll.be", "john1234");
        userRepository.save(user);

        Loan loan = new Loan("john.doe@ucll.be", "Effective Java", LocalDate.now().minusDays(10), LocalDate.now().minusDays(2));
        loanRepository.save(loan);
    }
}