package be.ucll.model;

import jakarta.persistence.*;
import jakarta.validation.constraints.*;

@Entity
@Table(name="users")
public class User {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private long id;

    @NotBlank(message = "Name is required.")
    private String name;

    @NotNull(message = "Age is required.")
    @Min(value = 0, message = "Age must be a positive integer.")
    @Max(value = 101, message = "Age can not be greater than 101.")
    private Integer age;

    @NotBlank(message = "E-mail is required.")
    @Email(message = "E-mail must be a valid email format.")
    private String email;

    @NotBlank(message = "Password is required.")
    @Size(min = 8, message = "Password must be at least 8 characters long.")
    private String password;

    protected User() {}

    public User(String name, Integer age, String email, String password) {
        setName(name);
        setAge(age);
        setEmail(email);
        setPassword(password);
    }

    public int getAge() {
        return age;
    }

    public void setAge(Integer age) {
//        if (age < 0 || age > 101) {
//            throw new RuntimeException("Age must be a positive integer between 0 and 101.");
//        }
        this.age = age;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
//        if (name == null || name.trim().isEmpty()){
//            throw new RuntimeException("Name is required.");
//        }
        this.name = name;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
//        if (email == null || !email.contains("@") || !email.contains(".")) {
//            throw new RuntimeException("E-mail must be a valid email format.");
//        }
        this.email = email;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
//        if (password == null || password.length() < 8) {
//            throw new RuntimeException("Password must be at least 8 characters long.");
//        }
        this.password = password;
    }

    public void updateNameAndAgeAndPassword(String name, int age, String email, String password) {
        if (!this.email.equals(email)) {
            throw new RuntimeException("Email cannot be changed.");
        }
        setName(name);
        setAge(age);
        setPassword(password);
    }
}