package be.ucll.model;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;

import java.time.Year;

public class Publication {
    @NotBlank(message = "Title is required.")
    private String title;

//    @NotNull(message = "Publication year is required")
    private Integer publicationYear;

    @NotNull(message = "Available copies is required.")
    @Positive(message = "Available copies must be a positive number.")
    private Integer availableCopies;

    public Publication(String title, Integer publicationYear, Integer availableCopies) {
        setTitle(title);
        setPublicationYear(publicationYear);
        setAvailableCopies(availableCopies);
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
//        if (title == null || title.trim().isEmpty()) {
//            throw new RuntimeException("Title is required");
//        }
        this.title = title;
    }

    public int getPublicationYear() {
        return publicationYear;
    }

    public void setPublicationYear(Integer publicationYear) {
        if (publicationYear < 0) {
            throw new RuntimeException("Publication year must be a positive integer");
        } else if (Year.now().getValue() < publicationYear) {
            throw new RuntimeException("Publication year cannot be in the future");
        }
        this.publicationYear = publicationYear;
    }

    public int getAvailableCopies() {
        return availableCopies;
    }

    public void setAvailableCopies(Integer availableCopies) {
//        if (availableCopies < 0) {
//            throw new RuntimeException("Available copies must be a positive number");
//        }
        this.availableCopies = availableCopies;
    }

    public void lendPublication() {
        if (availableCopies <= 0) {
            throw new RuntimeException("No available copies left for publication.");
        }
        availableCopies--;
    }
    public void returnPublication() {
        availableCopies++;
    }
}