package be.ucll.model;

import jakarta.persistence.*;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

import java.time.LocalDate;

@Entity
@Table(name = "loans")
public class Loan {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private long id;

    private String userEmail;
    @Column(name = "publication_title")
    private String publicationTitle;
    @NotNull(message = "Start date is required.")
    private LocalDate startDate;
    private LocalDate endDate;

    protected Loan() {}

    public Loan(String userEmail, String publicationTitle, LocalDate startDate, LocalDate endDate) {
//        this.userEmail = userEmail;
//        this.publicationTitle = publicationTitle;
//        this.startDate = startDate;
//        this.endDate = endDate;
        setUserEmail(userEmail);
        setPublicationTitle(publicationTitle);
        setStartDate(startDate);
        setEndDate(endDate);
    }

    public String getUserEmail() {
        return userEmail;
    }

    public void setUserEmail(String userEmail) {
        if (userEmail == null || userEmail.trim().isEmpty()) {
            throw new RuntimeException("User email is required.");
        }
        this.userEmail = userEmail;
    }

    public String getPublicationTitle() {
        return publicationTitle;
    }

    public void setPublicationTitle(String publicationTitle) {
        if (publicationTitle == null || publicationTitle.trim().isEmpty()) {
            throw new RuntimeException("List is required.");
        }
        this.publicationTitle = publicationTitle;
    }

    public LocalDate getStartDate() {
        return startDate;
    }

    public void setStartDate(LocalDate startDate) {
        if (LocalDate.now().isBefore(startDate)) {
            throw new RuntimeException("Start date cannot be in the future.");
        }

        if (endDate != null) {
            if (endDate.isBefore(startDate)) {
                throw new RuntimeException("Start date cannot be after end date.");
            }
        }
        this.startDate = startDate;
    }

    public LocalDate getEndDate() {
        return endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }
}