package be.ucll.model;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Pattern;

public class Book extends Publication {
    @NotBlank(message = "Author is required")
    private String author;

    @NotBlank(message = "ISBN is required.")
    @Pattern(regexp = "\\d{13}", message = "ISBN must contain exactly 13 digits.")
    private String ISBN;

    public Book(String title, String author, String ISBN, int publicationYear, int availableCopies) {
        super(title, publicationYear, availableCopies);
        setAuthor(author);
        setISBN(ISBN);
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
//        if (author == null || author.trim().isEmpty()) {
//            throw new RuntimeException("Author is required");
//        }
        this.author = author;
    }

    public String getISBN() {
        return ISBN;
    }

    public void setISBN(String ISBN) {
//        if (ISBN == null || ISBN.trim().isEmpty()) {
//            throw new RuntimeException("ISBN is required.");
//        } else if (!ISBN.matches("\\d{13}")) {
//            throw new RuntimeException("ISBN must contain exactly 13 digits.");
//        }
        this.ISBN = ISBN;
    }
}