/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.wrapper;

import de.butzlabben.inventory.OrcItem;
import de.butzlabben.world.config.GuiConfig;
import de.butzlabben.world.wrapper.GeneratorSettings;

public class WorldTemplate {
    public final String name;
    public final String permission;
    public final OrcItem icon;
    public final int slot;
    public final int cost;
    public final GeneratorSettings generatorSettings;

    public WorldTemplate(String name, String permission, int cost, GeneratorSettings generatorSettings) {
        this.name = name;
        this.permission = permission;
        this.cost = cost;
        this.generatorSettings = generatorSettings;
        this.icon = GuiConfig.getItem("worldchoose." + name);
        this.slot = GuiConfig.getSlot("worldchoose." + name);
        this.icon.setOnClick((p, inv, item) -> {
            p.closeInventory();
            p.chat("/ws get " + name);
        });
    }

    public int getSlot() {
        return this.slot;
    }

    public int getCost() {
        return this.cost;
    }

    public OrcItem getIcon() {
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return "plugins/WorldSystem/worldsources/" + this.name;
    }

    public String getPermission() {
        return this.permission;
    }

    public GeneratorSettings getGeneratorSettings() {
        return this.generatorSettings;
    }
}

