/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.util.database;

import de.butzlabben.world.config.PluginConfig;
import de.butzlabben.world.util.VersionUtil;
import de.butzlabben.world.util.database.DatabaseConnection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class SqliteConnection
extends DatabaseConnection {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(String file) {
        if (VersionUtil.getVersion() <= 8) {
            Bukkit.getLogger().log(Level.SEVERE, "[WorldSystem | SQLite] ========================================================");
            Bukkit.getLogger().log(Level.SEVERE, "[WorldSystem | SQLite] SQLite is not available in 1.8.");
            Bukkit.getLogger().log(Level.SEVERE, "[WorldSystem | SQLite] Please consider using MySQL or disable the use_last_location option");
            Bukkit.getLogger().log(Level.SEVERE, "[WorldSystem | SQLite] ========================================================");
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                Class.forName("com.mysql.jdbc.Driver");
                Class.forName("org.sqlite.JDBC");
            }
            catch (ClassNotFoundException e) {
                Bukkit.getLogger().log(Level.SEVERE, "[WorldSystem | SQLite] Drivers are not working properly");
                return;
            }
            try {
                this.connection = DriverManager.getConnection("jdbc:sqlite:" + file);
                Bukkit.getLogger().log(Level.INFO, "[WorldSystem | SQLite] Connected to local file database");
            }
            catch (SQLException e) {
                Bukkit.getLogger().log(Level.SEVERE, "[WorldSystem | SQLite] Failed to connect with given server:");
                e.printStackTrace();
            }
        }
    }

    @Override
    public void connect() {
        this.connect(PluginConfig.getSqliteFile());
    }
}

