/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.util.database;

import de.butzlabben.world.config.PluginConfig;
import de.butzlabben.world.util.database.DatabaseUtil;
import de.butzlabben.world.util.database.MysqlConnection;
import de.butzlabben.world.util.database.SqliteConnection;

public class DatabaseProvider {
    public static DatabaseProvider instance = new DatabaseProvider();
    public final DatabaseUtil util;

    private DatabaseProvider() {
        String dbType = PluginConfig.getDatabaseType();
        if (dbType.equalsIgnoreCase("sqlite")) {
            this.util = new SqliteConnection();
        } else if (dbType.equalsIgnoreCase("mysql")) {
            this.util = new MysqlConnection();
        } else {
            throw new IllegalArgumentException("Unknown database type: " + dbType);
        }
    }

    public static DatabaseProvider getInstance() {
        return instance;
    }

    public DatabaseUtil getUtil() {
        return this.util;
    }
}

