/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.gui;

import de.butzlabben.inventory.DependListener;
import de.butzlabben.inventory.OrcInventory;
import de.butzlabben.inventory.OrcItem;
import de.butzlabben.world.config.GuiConfig;
import de.butzlabben.world.gui.WorldSystemGUI;
import de.butzlabben.world.gui.clicklistener.ComingSoonClickListener;
import de.butzlabben.world.gui.clicklistener.CommandExecutorClickListener;
import de.butzlabben.world.gui.worldoption.FireStatus;
import de.butzlabben.world.gui.worldoption.TntStatus;
import de.butzlabben.world.wrapper.WorldPlayer;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class WorldOptionsGUI
extends OrcInventory {
    public static final HashMap<UUID, String> data = new HashMap();
    private static final String path = "options.world.";

    public WorldOptionsGUI() {
        super(GuiConfig.getTitle((FileConfiguration)GuiConfig.getConfig(), "options.world"), GuiConfig.getRows("options.world"), GuiConfig.isFill("options.world"));
        this.loadItem("fire", "/ws fire", true, new FireStatus());
        this.loadItem("tnt", "/ws tnt", true, new TntStatus());
        if (!GuiConfig.isEnabled("options.world.reset")) {
            return;
        }
        OrcItem item = GuiConfig.getItem("options.world.reset");
        if (item != null) {
            item.setOnClick((p, inv, i) -> {
                p.closeInventory();
                p.chat("/ws reset");
            });
            this.addItem(GuiConfig.getSlot("options.world.reset"), item);
        }
        if (GuiConfig.isEnabled("options.world.back")) {
            OrcItem back = OrcItem.back.clone();
            back.setOnClick((p, inv, i) -> {
                p.closeInventory();
                p.openInventory(new WorldSystemGUI().getInventory(p));
            });
            this.addItem(GuiConfig.getSlot("options.world.back"), back);
        }
    }

    public void loadItem(String subpath, String message, boolean state, DependListener depend) {
        if (!GuiConfig.isEnabled(path + subpath)) {
            return;
        }
        OrcItem item = GuiConfig.getItem(path + subpath);
        if (item != null) {
            if (message == null) {
                item.setOnClick(new ComingSoonClickListener());
            } else {
                item.setOnClick(new CommandExecutorClickListener(message));
            }
            if (state) {
                if (depend == null) {
                    this.addItem(GuiConfig.getState(path + subpath), OrcItem.coming_soon.clone());
                } else {
                    this.addItem(GuiConfig.getState(path + subpath), OrcItem.disabled.clone().setDepend(depend));
                }
            }
            this.addItem(GuiConfig.getSlot(path + subpath), item);
        }
    }

    public void loadItem(String subpath, String message, boolean state) {
        this.loadItem(subpath, message, state, null);
    }

    public void loadItem(String subpath, boolean state) {
        this.loadItem(subpath, null, state);
    }

    @Override
    public Inventory getInventory(Player p, String title) {
        if (data.containsKey(p.getUniqueId())) {
            return super.getInventory(p, title.replaceAll("%data", data.get(p.getUniqueId())));
        }
        return super.getInventory(p, title);
    }

    @Override
    public Inventory getInventory(Player p) {
        if (data.containsKey(p.getUniqueId())) {
            return super.getInventory(p, this.getTitle().replaceAll("%data", data.get(p.getUniqueId())));
        }
        return super.getInventory(p, this.getTitle());
    }

    public boolean canOpen(Player p) {
        return new WorldPlayer(p).isOwnerofWorld();
    }
}

