/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.config;

import de.butzlabben.world.WorldSystem;
import de.butzlabben.world.config.PluginConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class MessageConfig {
    private static final List<String> defaultCmdHelp = new ArrayList<String>(20);
    private static File file;

    private MessageConfig() {
    }

    public static void checkConfig(File f) {
        file = f;
        if (!file.exists()) {
            try {
                InputStream in = ((WorldSystem)JavaPlugin.getPlugin(WorldSystem.class)).getResource("languages/" + f.getName());
                if (in == null) {
                    in = ((WorldSystem)JavaPlugin.getPlugin(WorldSystem.class)).getResource("custom.yml");
                }
                Files.copy(in, file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                WorldSystem.logger().log(Level.SEVERE, "Wasn't able to create Message file");
                e.printStackTrace();
            }
        }
    }

    private static YamlConfiguration getConfig() {
        try {
            return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getRawMessage(String path, String alt) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)MessageConfig.getConfig().getString(path, alt));
    }

    private static String getMessage(String path, String alt) {
        return PluginConfig.getPrefix() + MessageConfig.getRawMessage(path, alt);
    }

    public static String getNoPermission() {
        return MessageConfig.getMessage("nopermission", "\u00a7cYou don't have permissions!");
    }

    public static String getSettingUpWorld() {
        return MessageConfig.getMessage("world.setting_up", "\u00a7aSetting up world...");
    }

    public static String getPlayerList() {
        return MessageConfig.getMessage("world.playerlist", "Player in this world: %player");
    }

    public static String getLagDetection() {
        return MessageConfig.getMessage("lagdetection", "Lagdetection in world from: \u00a7c%world");
    }

    public static String getWrongUsage() {
        return MessageConfig.getMessage("wrong_usage", "\u00a7c%usage");
    }

    public static String getNoWorldOwn() {
        return MessageConfig.getMessage("world.does_not_exists.own", "\u00a7cYou don't have a world!");
    }

    public static String getNoWorldOther() {
        return MessageConfig.getMessage("world.does_not_exists.other", "\u00a7cThis player doesn't has a world!");
    }

    public static String getNotRegistered() {
        return MessageConfig.getMessage("not_registered", "\u00a7cThis player hasn't joined yet!");
    }

    public static String getAlreadyMember() {
        return MessageConfig.getMessage("member.already_added", "\u00a7cThis player is already a member!");
    }

    public static String getMemberAdded() {
        return MessageConfig.getMessage("member.added", "You have added &c%player&6 to your World!");
    }

    public static String getUnknownError() {
        return MessageConfig.getMessage("unknown_error", "\u00a7cSomething went wrong...");
    }

    public static String getDeleteWorldOwn() {
        return MessageConfig.getMessage("world.delete.own", "\u00a7cYour world was deleted!");
    }

    public static String getDeleteWorldOther() {
        return MessageConfig.getMessage("world.delete.other", "You deleted the world of \u00a7c%player\u00a76!");
    }

    public static String getNoMemberOwn() {
        return MessageConfig.getMessage("member.not_added.own", "\u00a7cThis player isn't a member!");
    }

    public static String getMemberRemoved() {
        return MessageConfig.getMessage("member.removed", "You removed \u00a7c%player\u00a76 from your world!");
    }

    public static String getNoMemberAdded() {
        return MessageConfig.getMessage("member.no_one_added", "\u00a7cThere are no members added");
    }

    public static String getWorldAlreadyExists() {
        return MessageConfig.getMessage("world.already_exists", "\u00a7cYou already have a world!");
    }

    public static String getWorldCreated() {
        return MessageConfig.getMessage("world.created", "Your world is now ready. Get there with \u00a7a/ws home");
    }

    public static String getWorldStillCreating() {
        return MessageConfig.getMessage("world.still_creating", "\u00a7cWorld is still creating");
    }

    public static String getNotOnWorld() {
        return MessageConfig.getMessage("world.not_on", "\u00a7cYou are not on a world!");
    }

    public static String getWorldStillLoaded() {
        return MessageConfig.getMessage("world.still_loaded", "\u00a7cYour world is still loaded!");
    }

    public static String getNoRequestSend() {
        return MessageConfig.getMessage("request.not_sent", "\u00a7cYou didn't send a request!");
    }

    public static String getWorldReseted() {
        return MessageConfig.getMessage("world.reseted", "Your world was reseted!");
    }

    public static String getInvalidInput() {
        return MessageConfig.getMessage("request.invalid_input", "\u00a7c%input is not a valid input!");
    }

    public static String getRequestAlreadySent() {
        return MessageConfig.getMessage("request.already_sent", "\u00a7cYou already sent a request!");
    }

    public static String getRequestExpired() {
        return MessageConfig.getMessage("request.expired", "\u00a7cYou request is expired!");
    }

    public static String getTimeUntilExpires() {
        return MessageConfig.getMessage("request.until_expire", "\u00a7cYour request expires in %time seconds!");
    }

    public static String getConfirmRequest() {
        return MessageConfig.getMessage("request.confirm", "\u00a7cPlease confirm reset of your world: %command");
    }

    public static String getNoMemberOther() {
        return MessageConfig.getMessage("member.not_added.other", "\u00a7cYou are not added to this world!");
    }

    public static String getInfoOwner() {
        return MessageConfig.getMessage("info.owner", "Owner: %data");
    }

    public static String getInfoId() {
        return MessageConfig.getMessage("info.id", "ID: %data");
    }

    public static String getInfoMember() {
        return MessageConfig.getMessage("info.member", "Member: %data");
    }

    public static String getInfoTnt() {
        return MessageConfig.getMessage("info.tnt", "TNT: %data");
    }

    public static String getInfoFire() {
        return MessageConfig.getMessage("info.fire", "Fire: %data");
    }

    public static String getInfoEnabled() {
        return MessageConfig.getRawMessage("info.enabled", "\u00a7aOn");
    }

    public static String getInfoDisabled() {
        return MessageConfig.getRawMessage("info.disabled", "\u00a7cOff");
    }

    public static String getToggleGameModeEnabled() {
        return MessageConfig.getMessage("toggle.gamemode.enabled", "\u00a7a%player\u00a76 can now change his gamemode!");
    }

    public static String getToggleGameModeDisabled() {
        return MessageConfig.getMessage("toggle.gamemode.disabled", "\u00a7c%player\u00a76 can no longer change his gamemode!");
    }

    public static String getToggleTeleportEnabled() {
        return MessageConfig.getMessage("toggle.teleport.enabled", "\u00a7a%player\u00a76 can now teleport!");
    }

    public static String getToggleTeleportDisabled() {
        return MessageConfig.getMessage("toggle.teleport.disabled", "\u00a7c%player\u00a76 can no longer teleport!");
    }

    public static String getToggleBuildEnabled() {
        return MessageConfig.getMessage("toggle.build.enabled", "\u00a7a%player\u00a76 can now build!");
    }

    public static String getToggleBuildDisabled() {
        return MessageConfig.getMessage("toggle.build.disabled", "\u00a7c%player\u00a76 can no longer build!");
    }

    public static String getToggleWorldeditEnabled() {
        return MessageConfig.getMessage("toggle.worldedit.enabled", "\u00a7a%player\u00a76 can now use WorldEdit!");
    }

    public static String getToggleWorldeditDisabled() {
        return MessageConfig.getMessage("toggle.worldedit.disabled", "\u00a7c%player\u00a76 can no longer use WorldEdit!");
    }

    public static String getToggleFireEnabled() {
        return MessageConfig.getMessage("toggle.fire.enabled", "\u00a7aYou activated fire!");
    }

    public static String getToggleFireDisabled() {
        return MessageConfig.getMessage("toggle.fire.disabled", "\u00a7cYou deactivated fire!");
    }

    public static String getToggleTntEnabled() {
        return MessageConfig.getMessage("toggle.tnt.enabled", "\u00a7aYou activated TNT-Damage!");
    }

    public static String getToggleTntDisabled() {
        return MessageConfig.getMessage("toggle.tnt.disabled", "\u00a7cYou deactivated TNT-Damage!");
    }

    public static String getDeleteCommandHelp() {
        return MessageConfig.getRawMessage("command_help.delete_command", "/ws delete \u00a78- \u00a77Will delete a World");
    }

    public static List<String> getCommandHelp() {
        List<String> list = MessageConfig.getConfig().getStringList("command_help.list");
        if (list == null) {
            list = defaultCmdHelp;
        }
        list = list.stream().map(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s)).collect(Collectors.toList());
        return list;
    }

    public static String getHomeSet() {
        return MessageConfig.getMessage("world.set_home", "You set the home");
    }

    public static String getNotEnoughMoney() {
        return MessageConfig.getMessage("not_enough_money", "You do not have enough money");
    }

    static {
        defaultCmdHelp.add("/ws get \u00a78- \u00a77Will give you a World");
        defaultCmdHelp.add("/ws home \u00a78- \u00a77Teleports you on your World");
        defaultCmdHelp.add("/ws sethome \u00a78- \u00a77Sets a specific home");
        defaultCmdHelp.add("/ws tp \u00a78- \u00a77Teleports you on a specific World");
        defaultCmdHelp.add("/ws addmember \u00a78- \u00a77Adds a player to your World");
        defaultCmdHelp.add("/ws delmember\u00a78 - \u00a77Removes a player from your World");
        defaultCmdHelp.add("/ws tnt \u00a78- \u00a77Allows/Denys TNT on your World");
        defaultCmdHelp.add("/ws fire \u00a78- \u00a77Allows/Denys Fire on your World");
        defaultCmdHelp.add("/ws togglechgm \u00a78- \u00a77Allows/Denys a player changing gamemode");
        defaultCmdHelp.add("/ws togglebuild \u00a78- \u00a77Allows/Denys a player building");
        defaultCmdHelp.add("/ws toggletp \u00a78- \u00a77Allows/Denys a player teleporting");
        defaultCmdHelp.add("/ws info \u00a78- \u00a77Shows information about the World");
        defaultCmdHelp.add("/ws reset \u00a78- \u00a77Will reset your World");
    }
}

