/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.config;

import de.butzlabben.inventory.OrcItem;
import de.butzlabben.world.WorldSystem;
import de.butzlabben.world.config.PluginConfig;
import de.butzlabben.world.util.VersionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class GuiConfig {
    private static File file;

    private GuiConfig() {
    }

    public static void checkConfig(File f) {
        file = f;
        if (!file.exists()) {
            try {
                String guiFileResource = VersionUtil.getVersion() >= 14 ? "1_14_gui.yml" : (VersionUtil.getVersion() == 13 ? "1_13_gui.yml" : "old_gui.yml");
                InputStream in = ((WorldSystem)JavaPlugin.getPlugin(WorldSystem.class)).getResource(guiFileResource);
                Files.copy(in, file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                WorldSystem.logger().log(Level.SEVERE, "Wasn't able to create Config");
                e.printStackTrace();
            }
        }
        OrcItem.enabled = GuiConfig.getEnabled();
        OrcItem.disabled = GuiConfig.getDisabled();
        OrcItem.coming_soon = GuiConfig.getComingSoon();
        OrcItem.back = GuiConfig.getBack();
        OrcItem.fill = GuiConfig.getFill();
    }

    public static YamlConfiguration getConfig() {
        try {
            return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getSlot(String path) {
        YamlConfiguration cfg = GuiConfig.getConfig();
        return (cfg.getInt(path + ".slot.row") - 1) * 9 + cfg.getInt(path + ".slot.col") - 1;
    }

    public static int getState(String path) {
        YamlConfiguration cfg = GuiConfig.getConfig();
        return (cfg.getInt(path + ".state.row") - 1) * 9 + cfg.getInt(path + ".state.col") - 1;
    }

    public static boolean isEnabled(String path) {
        return GuiConfig.getConfig().getBoolean(path + ".enabled", true);
    }

    public static int getRows(String path) {
        return GuiConfig.getConfig().getInt(path + ".rows", 1);
    }

    public static String getDisplay(FileConfiguration cfg, String path) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)cfg.getString(path + ".display"));
    }

    public static ArrayList<String> getLore(FileConfiguration cfg, String path) {
        List list = cfg.getStringList(path + ".lore");
        ArrayList<String> colored = new ArrayList<String>(list.size());
        for (String s : list) {
            colored.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
        }
        return colored;
    }

    public static byte getData(FileConfiguration cfg, String path) {
        return (byte)cfg.getInt(path + ".data", 0);
    }

    public static String getTitle(FileConfiguration cfg, String path) {
        return cfg.getString(path + ".title");
    }

    public static Material getMaterial(FileConfiguration cfg, String path) {
        try {
            return Material.valueOf((String)cfg.getString(path + ".material").toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            Bukkit.getConsoleSender().sendMessage(PluginConfig.getPrefix() + "\u00a7cUnknown material: " + path);
            return null;
        }
    }

    public static OrcItem getItem(String path) {
        YamlConfiguration cfg = GuiConfig.getConfig();
        try {
            return new OrcItem(GuiConfig.getMaterial((FileConfiguration)cfg, path), GuiConfig.getData((FileConfiguration)cfg, path), GuiConfig.getDisplay((FileConfiguration)cfg, path), GuiConfig.getLore((FileConfiguration)cfg, path));
        }
        catch (Exception exception) {
            try {
                return new OrcItem(GuiConfig.getMaterial((FileConfiguration)cfg, path), GuiConfig.getDisplay((FileConfiguration)cfg, path), GuiConfig.getLore((FileConfiguration)cfg, path));
            }
            catch (Exception exception2) {
                return OrcItem.error.clone().setDisplay("\u00a7c" + path);
            }
        }
    }

    public static OrcItem getEnabled() {
        return GuiConfig.getItem("options.enabled");
    }

    public static OrcItem getDisabled() {
        return GuiConfig.getItem("options.disabled");
    }

    public static OrcItem getComingSoon() {
        return GuiConfig.getItem("options.coming_soon");
    }

    private static OrcItem getBack() {
        return GuiConfig.getItem("options.back");
    }

    private static OrcItem getFill() {
        return GuiConfig.getItem("options.fill");
    }

    public static boolean isFill(String path) {
        return GuiConfig.getConfig().getBoolean(path + ".fill");
    }

    public static Material getSkullItem() {
        return GuiConfig.getMaterial((FileConfiguration)GuiConfig.getConfig(), "options.players.playerhead");
    }
}

