/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.config;

import de.butzlabben.WorldSystem.data.PlayerWorld;
import de.butzlabben.WorldSystem.data.WorldSystemData;
import de.butzlabben.world.config.PluginConfig;
import de.butzlabben.world.util.PlayerWrapper;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DependenceConfig {
    private UUID uuid;

    public DependenceConfig() {
        this.setConfig();
    }

    public DependenceConfig(String s) {
        OfflinePlayer op = null;
        try {
            op = PlayerWrapper.getOfflinePlayer(UUID.fromString(s));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (op == null) {
            op = PlayerWrapper.getOfflinePlayer(s);
        }
        this.uuid = op.getUniqueId();
    }

    public DependenceConfig(Player p) {
        this.uuid = p.getUniqueId();
        this.refreshName();
    }

    public DependenceConfig(OfflinePlayer p) {
        this.uuid = p.getUniqueId();
        this.refreshName();
    }

    public DependenceConfig(UUID uuid) {
        this.uuid = uuid;
    }

    public static int getHighestID() {
        WorldSystemData db = WorldSystemData.connect();
        int highest_id = db.getHighestID();
        return highest_id;
    }

    public static void checkWorlds() {
        PlayerWorld[] worlds;
        long deleteTime = 86400000L * PluginConfig.deleteAfter();
        long now = System.currentTimeMillis();
        WorldSystemData db = WorldSystemData.connect();
        for (PlayerWorld s : worlds = db.getAllWorlds()) {
            long lastLoaded = s.getLast_loaded();
            long diff = now - lastLoaded;
            if (diff <= deleteTime) continue;
            Bukkit.getConsoleSender().sendMessage(PluginConfig.getPrefix() + "World of " + s + " was not loaded for too long. Deleting!");
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("ws delete " + s));
        }
    }

    private void setConfig() {
    }

    public void refreshName() {
        if (this.hasWorld()) {
            String uuid = this.uuid.toString();
            String new_name = PlayerWrapper.getOfflinePlayer(this.uuid).getName();
            WorldSystemData db = WorldSystemData.connect();
            db.update_name(uuid, new_name);
        }
    }

    public void createNewEntry() {
        WorldSystemData db = WorldSystemData.connect();
        int id = db.getHighestID() + 1;
        String uuid = this.uuid.toString();
        String name = PlayerWrapper.getOfflinePlayer(this.uuid).getName();
        long last_loaded = System.currentTimeMillis();
        PlayerWorld world = new PlayerWorld(id, uuid, name, last_loaded);
        db.create_new_world_record(world);
    }

    public boolean hasWorld() {
        WorldSystemData db = WorldSystemData.connect();
        int count = db.getWorldCountForPlayer(this.uuid.toString());
        return count >= 1;
    }

    public String getWorldname() {
        String uuid = this.uuid.toString();
        WorldSystemData db = WorldSystemData.connect();
        PlayerWorld[] worlds = db.getWorldsForPlayer(uuid);
        return "ID" + worlds[0].getWorld_id() + "-" + uuid;
    }

    public String getWorldNameByOfflinePlayer() {
        return this.getWorldname();
    }

    public void setLastLoaded() {
        String uuid = this.uuid.toString();
        long new_time = System.currentTimeMillis();
        WorldSystemData db = WorldSystemData.connect();
        db.update_last_loaded(uuid, new_time);
    }

    public int getID() {
        WorldSystemData db = WorldSystemData.connect();
        PlayerWorld[] worlds = db.getWorldsForPlayer(this.uuid.toString());
        return worlds[0].getWorld_id();
    }

    public OfflinePlayer getOwner() {
        return PlayerWrapper.getOfflinePlayer(this.uuid);
    }
}

