/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.command.commands;

import de.butzlabben.world.WorldSystem;
import de.butzlabben.world.config.DependenceConfig;
import de.butzlabben.world.config.MessageConfig;
import de.butzlabben.world.config.PluginConfig;
import de.butzlabben.world.config.WorldConfig;
import de.butzlabben.world.event.WorldResetEvent;
import de.butzlabben.world.event.WorldToggleFireEvent;
import de.butzlabben.world.event.WorldToggleTntEvent;
import de.butzlabben.world.gui.WorldChooseGUI;
import de.butzlabben.world.util.PlayerPositions;
import de.butzlabben.world.wrapper.SystemWorld;
import de.butzlabben.world.wrapper.WorldPlayer;
import de.butzlabben.world.wrapper.WorldTemplate;
import de.butzlabben.world.wrapper.WorldTemplateProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.WorldCreator;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class WorldSettingsCommands {
    private static final ArrayList<Player> toConfirm = new ArrayList();

    public boolean resetCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            DependenceConfig dc = new DependenceConfig(p);
            String worldname = dc.getWorldname();
            SystemWorld sw = SystemWorld.getSystemWorld(worldname);
            if (!dc.hasWorld()) {
                p.sendMessage(MessageConfig.getNoWorldOwn());
                return false;
            }
            if (args.length > 1) {
                if (args[1].equalsIgnoreCase("confirm")) {
                    if (sw.isLoaded()) {
                        sw.directUnload(Bukkit.getWorld((String)worldname));
                    }
                    if (!toConfirm.contains(p)) {
                        p.sendMessage(MessageConfig.getNoRequestSend());
                        return false;
                    }
                    WorldResetEvent event = new WorldResetEvent((CommandSender)p, sw);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return false;
                    }
                    if (sw.isLoaded()) {
                        p.sendMessage(MessageConfig.getWorldStillLoaded());
                        return false;
                    }
                    WorldConfig config = WorldConfig.getWorldConfig(worldname);
                    PlayerPositions.instance.deletePositions(config);
                    File f = new File(PluginConfig.getWorlddir() + "/" + worldname);
                    if (!PluginConfig.isMultiChoose()) {
                        WorldTemplate template2 = WorldTemplateProvider.getInstance().getTemplate(PluginConfig.getDefaultWorldTemplate());
                        if (template2 != null) {
                            this.createWorld(p, worldname, f, template2, sw);
                        } else {
                            p.sendMessage(PluginConfig.getPrefix() + "\u00a7cError in config at \"worldtemplates.default\"");
                            p.sendMessage(PluginConfig.getPrefix() + "\u00a7cPlease contact an administrator");
                        }
                    } else {
                        WorldChooseGUI.letChoose(p, template -> {
                            if (template != null) {
                                this.createWorld(p, worldname, f, (WorldTemplate)template, sw);
                            } else {
                                p.sendMessage(PluginConfig.getPrefix() + "\u00a7cError in config at \"worldtemplates.default\"");
                                p.sendMessage(PluginConfig.getPrefix() + "\u00a7cPlease contact an administrator");
                            }
                        });
                    }
                } else {
                    p.sendMessage(MessageConfig.getInvalidInput().replaceAll("%input", "\"reset " + args[1] + "\""));
                }
            } else {
                if (sw.isLoaded()) {
                    sw.directUnload(Bukkit.getWorld((String)worldname));
                }
                if (toConfirm.contains(p)) {
                    p.sendMessage(MessageConfig.getRequestAlreadySent());
                    return false;
                }
                int time = PluginConfig.getRequestExpire();
                p.sendMessage(MessageConfig.getConfirmRequest().replaceAll("%command", "/ws reset confirm"));
                p.sendMessage(MessageConfig.getTimeUntilExpires().replaceAll("%time", String.valueOf(time)));
                toConfirm.add(p);
                Bukkit.getScheduler().runTaskLater((Plugin)WorldSystem.getInstance(), () -> {
                    if (toConfirm.contains(p)) {
                        p.sendMessage(MessageConfig.getRequestExpired());
                        toConfirm.remove(p);
                    }
                }, (long)time * 20L);
            }
            return true;
        }
        sender.sendMessage("No Console");
        return false;
    }

    public boolean setHomeCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Location playerLocation;
            Player p = (Player)sender;
            WorldPlayer wp = new WorldPlayer(p);
            if (!wp.isOnSystemWorld()) {
                p.sendMessage(MessageConfig.getNotOnWorld());
                return false;
            }
            if (!wp.isOwnerofWorld()) {
                p.sendMessage(MessageConfig.getNoPermission());
                return false;
            }
            if (!p.hasPermission("ws.sethome")) {
                p.sendMessage(MessageConfig.getNoPermission());
                return false;
            }
            WorldConfig config = WorldConfig.getWorldConfig(p.getWorld().getName());
            config.home = playerLocation = p.getLocation();
            WorldSystem.logger().log(Level.INFO, "installed");
            try {
                if (config.home == playerLocation) {
                    WorldSystem.logger().log(Level.INFO, "registered");
                } else {
                    WorldSystem.logger().log(Level.INFO, "registered incorrectly");
                }
                config.save();
                p.sendMessage(MessageConfig.getHomeSet());
            }
            catch (IOException e) {
                p.sendMessage(MessageConfig.getUnknownError() + ": " + e.getMessage());
                e.printStackTrace();
            }
            return true;
        }
        sender.sendMessage("No Console");
        return false;
    }

    public boolean tntCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            DependenceConfig dc = new DependenceConfig(p);
            if (!dc.hasWorld()) {
                p.sendMessage(MessageConfig.getNoWorldOwn());
                return false;
            }
            WorldConfig wc = WorldConfig.getWorldConfig(dc.getWorldname());
            boolean tnt = wc.isTnt();
            WorldToggleTntEvent event = new WorldToggleTntEvent((CommandSender)p, SystemWorld.getSystemWorld(dc.getWorldname()), tnt);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            wc.setTnt(p.getUniqueId(), !tnt);
            try {
                wc.save();
            }
            catch (IOException e) {
                p.sendMessage(PluginConfig.getPrefix() + "\u00a7cSomething went wrong");
                e.printStackTrace();
            }
            tnt = wc.isTnt();
            if (tnt) {
                p.sendMessage(MessageConfig.getToggleTntEnabled());
            } else {
                p.sendMessage(MessageConfig.getToggleTntDisabled());
            }
            return true;
        }
        sender.sendMessage("No Console");
        return false;
    }

    public boolean fireCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            DependenceConfig dc = new DependenceConfig(p);
            if (!dc.hasWorld()) {
                p.sendMessage(MessageConfig.getNoWorldOwn());
                return false;
            }
            WorldConfig wc = WorldConfig.getWorldConfig(dc.getWorldname());
            boolean fire = wc.isFire();
            WorldToggleFireEvent event = new WorldToggleFireEvent((CommandSender)p, SystemWorld.getSystemWorld(dc.getWorldname()), fire);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            wc.setFire(p.getUniqueId(), !fire);
            try {
                wc.save();
            }
            catch (IOException e) {
                p.sendMessage(PluginConfig.getPrefix() + "\u00a7cSomething went wrong");
                e.printStackTrace();
            }
            fire = wc.isFire();
            if (fire) {
                p.sendMessage(MessageConfig.getToggleFireEnabled());
            } else {
                p.sendMessage(MessageConfig.getToggleFireDisabled());
            }
            return true;
        }
        sender.sendMessage("No Console");
        return false;
    }

    private void createWorld(Player p, String worldname, File f, WorldTemplate template, SystemWorld sw) {
        File[] files;
        if (f != null && (files = f.listFiles()) != null) {
            for (File file : files) {
                if (file.getName().equals("worldconfig.yml")) continue;
                FileUtils.deleteQuietly((File)file);
            }
        }
        try {
            File templateDirectory = new File(template.getPath());
            if (templateDirectory.isDirectory()) {
                FileUtils.copyDirectory((File)templateDirectory, (File)f);
            }
            toConfirm.remove(p);
            FileUtils.moveDirectoryToDirectory((File)f, (File)Bukkit.getWorldContainer(), (boolean)false);
            WorldConfig config = WorldConfig.getWorldConfig(worldname);
            config.home = null;
            config.setTemplateKey(template.getName());
            config.save();
            p.sendMessage(MessageConfig.getWorldReseted());
            WorldCreator creator = template.generatorSettings.asWorldCreator(worldname);
            sw.setCreating(true);
            WorldSystem.getInstance().getAdapter().create(creator, sw, () -> {
                if (p != null && p.isOnline()) {
                    p.sendMessage(MessageConfig.getWorldCreated());
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            p.sendMessage(MessageConfig.getUnknownError());
            WorldSystem.logger().log(Level.SEVERE, "Couldn't reset world of " + p.getName());
        }
    }
}

