/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world;

import de.butzlabben.world.GCRunnable;
import de.butzlabben.world.WorldCheckerRunnable;
import de.butzlabben.world.command.CommandRegistry;
import de.butzlabben.world.config.DependenceConfig;
import de.butzlabben.world.config.GuiConfig;
import de.butzlabben.world.config.MessageConfig;
import de.butzlabben.world.config.PluginConfig;
import de.butzlabben.world.config.SettingsConfig;
import de.butzlabben.world.listener.BlockListener;
import de.butzlabben.world.listener.CommandListener;
import de.butzlabben.world.listener.PlayerListener;
import de.butzlabben.world.listener.WorldEditListener;
import de.butzlabben.world.listener.WorldInitSkipSpawn;
import de.butzlabben.world.util.PapiExtension;
import de.butzlabben.world.util.PlayerPositions;
import de.butzlabben.world.util.VersionUtil;
import de.butzlabben.world.util.database.DatabaseProvider;
import de.butzlabben.world.wrapper.CreatorAdapter;
import de.butzlabben.world.wrapper.SystemWorld;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class WorldSystem
extends JavaPlugin {
    private static boolean is1_13Plus = false;
    private final String version = this.getDescription().getVersion();
    private CreatorAdapter creator;

    public static void createConfigs() {
        File folder = WorldSystem.getInstance().getDataFolder();
        File dir = new File(folder + "/worldsources");
        File config = new File(folder, "config.yml");
        File languages = new File(folder + "/languages");
        File gui = new File(folder, "gui.yml");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!languages.exists()) {
            languages.mkdirs();
        }
        PluginConfig.checkConfig(config);
        MessageConfig.checkConfig(new File(languages, "en.yml"));
        MessageConfig.checkConfig(new File(languages, "de.yml"));
        MessageConfig.checkConfig(new File(languages, "hu.yml"));
        MessageConfig.checkConfig(new File(languages, "nl.yml"));
        MessageConfig.checkConfig(new File(languages, "pl.yml"));
        MessageConfig.checkConfig(new File(languages, "es.yml"));
        MessageConfig.checkConfig(new File(languages, "ru.yml"));
        MessageConfig.checkConfig(new File(languages, "fi.yml"));
        MessageConfig.checkConfig(new File(languages, "ja.yml"));
        MessageConfig.checkConfig(new File(languages, "zh.yml"));
        MessageConfig.checkConfig(new File(languages, "fr.yml"));
        MessageConfig.checkConfig(new File(languages, PluginConfig.getLanguage() + ".yml"));
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)config);
        SettingsConfig.checkConfig();
        File worlddir = new File(cfg.getString("worldfolder"));
        if (!worlddir.exists()) {
            worlddir.mkdirs();
        }
        GuiConfig.checkConfig(gui);
    }

    public static WorldSystem getInstance() {
        return (WorldSystem)JavaPlugin.getPlugin(WorldSystem.class);
    }

    public static Logger logger() {
        return ((WorldSystem)WorldSystem.getPlugin(WorldSystem.class)).getLogger();
    }

    public void onEnable() {
        this.getCommand("ws").setExecutor((CommandExecutor)new CommandRegistry());
        this.getCommand("ws").setTabCompleter((TabCompleter)new CommandRegistry());
        if (VersionUtil.getVersion() >= 13) {
            is1_13Plus = true;
        }
        WorldSystem.createConfigs();
        DatabaseProvider.instance.util.connect();
        PlayerPositions.instance.checkTables();
        PluginManager pm = Bukkit.getPluginManager();
        pm.registerEvents((Listener)new PlayerListener(), (Plugin)this);
        pm.registerEvents((Listener)new BlockListener(), (Plugin)this);
        pm.registerEvents((Listener)new CommandListener(), (Plugin)this);
        pm.registerEvents((Listener)new WorldInitSkipSpawn(), (Plugin)this);
        if (pm.getPlugin("WorldEdit") != null) {
            pm.registerEvents((Listener)new WorldEditListener(), (Plugin)this);
        }
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new WorldCheckerRunnable(), 100L, (long)(20 * PluginConfig.getLagCheckPeriod()));
        if (PluginConfig.useGC()) {
            Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new GCRunnable(), 100L, (long)(20 * PluginConfig.getGCPeriod()));
        }
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
            for (World w : Bukkit.getWorlds()) {
                SystemWorld.tryUnloadLater(w);
            }
        }, 2400L, 2400L);
        WorldSystem.logger().log(Level.INFO, "Registered");
        if (Bukkit.getPluginManager().getPlugin("FastAsyncWorldEdit") != null && Bukkit.getPluginManager().getPlugin("WorldEdit") != null && PluginConfig.loadWorldsASync() && !is1_13Plus) {
            Bukkit.getConsoleSender().sendMessage(PluginConfig.getPrefix() + "Found FAWE! Worlds now will be created asynchronously");
        } else {
            this.creator = (c, sw, r) -> {
                Bukkit.getWorlds().add(c.createWorld());
                if (sw != null) {
                    sw.setCreating(false);
                }
                r.run();
            };
        }
        if (PluginConfig.shouldDelete()) {
            Bukkit.getConsoleSender().sendMessage(PluginConfig.getPrefix() + "Searching for old worlds to delete if not loaded for " + PluginConfig.deleteAfter() + " days");
            DependenceConfig.checkWorlds();
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PapiExtension().register();
        }
        Bukkit.getConsoleSender().sendMessage(PluginConfig.getPrefix() + "Successfully enabled WorldSystem v" + this.version);
    }

    public void onDisable() {
        for (World w : Bukkit.getWorlds()) {
            SystemWorld sw = SystemWorld.getSystemWorld(w.getName());
            if (sw == null || !sw.isLoaded()) continue;
            sw.directUnload(w);
        }
        DatabaseProvider.instance.util.close();
        Bukkit.getConsoleSender().sendMessage(PluginConfig.getPrefix() + "Successfully disabled WorldSystem v" + this.version);
    }

    public CreatorAdapter getAdapter() {
        return this.creator;
    }

    public static void disable_plugin() {
        Bukkit.getPluginManager().disablePlugin((Plugin)WorldSystem.getPlugin(WorldSystem.class));
    }
}

