/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.inventory.pages;

import de.butzlabben.inventory.OrcItem;
import de.butzlabben.inventory.pages.InventoryPage;
import de.butzlabben.inventory.pages.ItemConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;

public class PageGUICreator<T> {
    private final int elementsPerPage;
    private List<InventoryPage> invpages;

    public PageGUICreator() {
        this(36);
    }

    public PageGUICreator(int elementsPerPage) {
        this.elementsPerPage = elementsPerPage;
    }

    public void create(String title, Collection<T> elements, ItemConverter<T> converter) {
        int i;
        List items = elements.stream().map(r -> converter.convert(r)).collect(Collectors.toList());
        if (items == null || items.size() == 0) {
            return;
        }
        int pages = (int)Math.ceil((double)items.size() / (double)this.elementsPerPage < 1.0 ? 1.0 : Math.ceil((double)items.size() / (double)this.elementsPerPage));
        this.invpages = new ArrayList<InventoryPage>(pages);
        for (i = 1; i < pages + 1; ++i) {
            int start = i == 1 ? 0 : this.elementsPerPage * (i - 1);
            int end = items.size() < this.elementsPerPage * i ? items.size() : this.elementsPerPage * i;
            List<OrcItem> page = items.subList(start, end);
            InventoryPage invpage = new InventoryPage(title, i, pages);
            page.forEach(invpage::addItem);
            this.invpages.add(invpage);
        }
        for (i = 0; i < this.invpages.size(); ++i) {
            int beforeIndex = i == 0 ? this.invpages.size() - 1 : i - 1;
            int nextIndex = i == this.invpages.size() - 1 ? 0 : i + 1;
            this.invpages.get((int)i).before = this.invpages.get(beforeIndex);
            this.invpages.get((int)i).next = this.invpages.get(nextIndex);
        }
    }

    public void show(Player p) {
        p.openInventory(this.invpages.get(0).getInventory(p));
    }

    public List<InventoryPage> getInvPages() {
        return this.invpages;
    }
}

