/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.inventory;

import de.butzlabben.inventory.OrcItem;
import de.butzlabben.inventory.OrcListener;
import de.butzlabben.world.WorldSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;

public abstract class OrcInventory {
    protected final HashMap<Integer, OrcItem> items = new HashMap();
    protected String title;
    private int rows;
    private InventoryType type;

    public OrcInventory(String title) {
        Objects.requireNonNull(title, "title cannot be null");
        this.title = title;
    }

    public OrcInventory(String title, int rows) {
        this(title);
        if (rows <= 0 || rows > 6) {
            throw new IllegalArgumentException("rows cannot be smaller than 1 or bigger than 6");
        }
        this.rows = rows;
    }

    public OrcInventory(String title, int rows, boolean fill) {
        this(title, rows);
        if (fill) {
            for (int i = 0; i < rows * 9; ++i) {
                this.items.put(i, OrcItem.fill);
            }
        }
    }

    public OrcInventory(String title, InventoryType type) {
        this(title);
        if (type == null || type == InventoryType.CHEST) {
            this.type = null;
            this.rows = 3;
        } else {
            this.type = type;
        }
    }

    public void addItem(int slot, OrcItem item) {
        if (item == null) {
            this.removeItem(slot);
        } else {
            this.items.put(slot, item);
        }
    }

    public void addItem(int row, int col, OrcItem item) {
        this.addItem(row * 9 + col, item);
    }

    public void removeItem(int slot) {
        this.items.remove(slot);
    }

    public void removeItem(int row, int col) {
        this.removeItem(row * 9 + col);
    }

    public Inventory getInventory(Player p) {
        return this.getInventory(p, this.title);
    }

    public void redraw(Player p) {
        p.closeInventory();
        p.openInventory(this.getInventory(p));
    }

    public Inventory getInventory(Player p, String title) {
        int size;
        Inventory inv;
        if (this.type == null) {
            inv = Bukkit.createInventory(null, (int)(this.rows * 9), (String)title);
            size = this.rows * 9;
        } else {
            inv = Bukkit.createInventory(null, (InventoryType)this.type, (String)title);
            size = this.type.getDefaultSize();
        }
        for (Map.Entry<Integer, OrcItem> entry : this.items.entrySet()) {
            if (entry.getKey() >= 0 && entry.getKey() < size) {
                inv.setItem(entry.getKey().intValue(), entry.getValue().getItemStack(p));
                continue;
            }
            WorldSystem.logger().log(Level.SEVERE, "There is a problem with a configured Item!");
        }
        OrcListener.getInstance().register(p.getUniqueId(), this);
        return inv;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

