/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.wrapper;

import de.butzlabben.world.config.PluginConfig;
import de.butzlabben.world.wrapper.GeneratorSettings;
import de.butzlabben.world.wrapper.WorldTemplate;
import java.util.Collection;
import java.util.HashMap;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.configuration.ConfigurationSection;

public class WorldTemplateProvider {
    private static final WorldTemplateProvider instance = new WorldTemplateProvider();
    private final HashMap<String, WorldTemplate> templates = new HashMap();

    private WorldTemplateProvider() {
        this.reload();
    }

    public void reload() {
        this.templates.clear();
        ConfigurationSection section = PluginConfig.getConfig().getConfigurationSection("worldtemplates.templates");
        for (String key : section.getKeys(false)) {
            String name = section.getString(key + ".name");
            String permission = null;
            if (section.isString(key + ".permission")) {
                permission = section.getString(key + ".permission");
            }
            int cost = -1;
            if (section.isInt(key + ".cost")) {
                cost = section.getInt(key + ".cost");
            }
            GeneratorSettings settings = new GeneratorSettings();
            if (section.contains(key + ".generator")) {
                ConfigurationSection gSection = section.getConfigurationSection(key + ".generator");
                long seed = gSection.getLong("seed", 0L);
                String env = gSection.getString("environment");
                String type = gSection.getString("type");
                String generator = gSection.getString("generator");
                settings = new GeneratorSettings(seed, this.getEnvironment(env), this.getWorldType(type), generator);
            }
            this.templates.put(name, new WorldTemplate(name, permission, cost, settings));
        }
    }

    public static WorldTemplateProvider getInstance() {
        return instance;
    }

    public WorldTemplate getTemplate(String key) {
        return this.templates.get(key);
    }

    public Collection<WorldTemplate> getTemplates() {
        return this.templates.values();
    }

    private World.Environment getEnvironment(String env) {
        if (env == null) {
            return null;
        }
        try {
            return World.Environment.valueOf((String)env);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private WorldType getWorldType(String type) {
        if (type == null) {
            return null;
        }
        try {
            return WorldType.valueOf((String)type);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

