/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.wrapper;

import com.google.common.base.Preconditions;
import de.butzlabben.world.config.PluginConfig;
import de.butzlabben.world.config.WorldConfig;
import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class WorldPlayer {
    private final OfflinePlayer p;
    private final String worldname;

    public WorldPlayer(OfflinePlayer p, String worldname) {
        this.p = p;
        this.worldname = worldname;
    }

    public WorldPlayer(Player p) {
        this((OfflinePlayer)p, p.getWorld().getName());
    }

    public String getWorldname() {
        return this.worldname;
    }

    public boolean toggleBuild() {
        Preconditions.checkArgument((boolean)this.isOnSystemWorld(), (Object)"player must be for this on a systemworld");
        WorldConfig wc = WorldConfig.getWorldConfig(this.worldname);
        if (!wc.isMember(this.p.getUniqueId())) {
            return false;
        }
        boolean build = wc.canBuild(this.p.getUniqueId());
        build = !build;
        wc.setBuild(this.p.getUniqueId(), build);
        try {
            wc.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return build;
    }

    public boolean canBuild() {
        Preconditions.checkArgument((boolean)this.isOnSystemWorld(), (Object)"player must be for this on a systemworld");
        WorldConfig wc = WorldConfig.getWorldConfig(this.worldname);
        return wc.canBuild(this.p.getUniqueId());
    }

    public boolean toggleWorldEdit() {
        Preconditions.checkArgument((boolean)this.isOnSystemWorld(), (Object)"player must be for this on a systemworld");
        WorldConfig wc = WorldConfig.getWorldConfig(this.worldname);
        if (!wc.isMember(this.p.getUniqueId())) {
            return false;
        }
        boolean build = wc.canWorldEdit(this.p.getUniqueId());
        build = !build;
        wc.setWorldEdit(this.p.getUniqueId(), build);
        try {
            wc.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return build;
    }

    public boolean canWorldedit() {
        Preconditions.checkArgument((boolean)this.isOnSystemWorld(), (Object)"player must be for this on a systemworld");
        WorldConfig wc = WorldConfig.getWorldConfig(this.worldname);
        return wc.canWorldEdit(this.p.getUniqueId());
    }

    public boolean toggleTeleport() {
        Preconditions.checkArgument((boolean)this.isOnSystemWorld(), (Object)"player must be for this on a systemworld");
        WorldConfig wc = WorldConfig.getWorldConfig(this.worldname);
        if (!wc.isMember(this.p.getUniqueId())) {
            return false;
        }
        boolean teleport = wc.canTeleport(this.p.getUniqueId());
        teleport = !teleport;
        wc.setTeleport(this.p.getUniqueId(), teleport);
        try {
            wc.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return teleport;
    }

    public boolean canTeleport() {
        Preconditions.checkArgument((boolean)this.isOnSystemWorld(), (Object)"player must be for this on a systemworld");
        WorldConfig wc = WorldConfig.getWorldConfig(this.worldname);
        return wc.canTeleport(this.p.getUniqueId());
    }

    public boolean toggleGamemode() {
        Preconditions.checkArgument((boolean)this.isOnSystemWorld(), (Object)"player must be for this on a systemworld");
        WorldConfig wc = WorldConfig.getWorldConfig(this.worldname);
        if (!wc.isMember(this.p.getUniqueId())) {
            return false;
        }
        boolean changeGamemode = wc.canGamemode(this.p.getUniqueId());
        changeGamemode = !changeGamemode;
        wc.setGamemode(this.p.getUniqueId(), changeGamemode);
        try {
            wc.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return changeGamemode;
    }

    public boolean canChangeGamemode() {
        Preconditions.checkArgument((boolean)this.isOnSystemWorld(), (Object)"player must be for this on a systemworld");
        WorldConfig wc = WorldConfig.getWorldConfig(this.worldname);
        return wc.canGamemode(this.p.getUniqueId());
    }

    public boolean isMember() {
        Preconditions.checkArgument((boolean)this.isOnSystemWorld(), (Object)"player must be for this on a systemworld");
        WorldConfig wc = WorldConfig.getWorldConfig(this.worldname);
        return wc.isMember(this.p.getUniqueId());
    }

    public boolean isOnSystemWorld() {
        File worldconfig = new File(Bukkit.getWorldContainer(), this.worldname + "/worldconfig.yml");
        if (!worldconfig.exists()) {
            worldconfig = new File(PluginConfig.getWorlddir() + this.worldname + "/worldconfig.yml");
        }
        if (worldconfig.exists()) {
            YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)worldconfig);
            return cfg.getString("Informations.Owner.PlayerUUID") != null;
        }
        return false;
    }

    public OfflinePlayer getPlayer() {
        return this.p;
    }

    public boolean isOwnerofWorld() {
        if (!this.isOnSystemWorld()) {
            return false;
        }
        WorldConfig wc = WorldConfig.getWorldConfig(this.worldname);
        return wc.getOwner().equals(this.p.getUniqueId());
    }

    public boolean isMemberofWorld(String worldname) {
        WorldConfig wc = WorldConfig.getWorldConfig(worldname);
        return wc.isMember(this.p.getUniqueId());
    }
}

