/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.wrapper;

import com.google.common.base.Preconditions;
import de.butzlabben.WorldSystem;
import de.butzlabben.world.config.DependenceConfig;
import de.butzlabben.world.config.MessageConfig;
import de.butzlabben.world.config.PluginConfig;
import de.butzlabben.world.config.SettingsConfig;
import de.butzlabben.world.config.WorldConfig;
import de.butzlabben.world.event.WorldCreateEvent;
import de.butzlabben.world.event.WorldLoadEvent;
import de.butzlabben.world.event.WorldUnloadEvent;
import de.butzlabben.world.util.PlayerPositions;
import de.butzlabben.world.util.PlayerWrapper;
import de.butzlabben.world.util.VersionUtil;
import de.butzlabben.world.wrapper.WorldTemplate;
import de.butzlabben.world.wrapper.WorldTemplateProvider;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class SystemWorld {
    private static final HashMap<String, SystemWorld> cached = new HashMap();
    private World w;
    private String worldname;
    private boolean unloading = false;
    private boolean creating = false;
    private BukkitTask unloadLaterTask;

    private SystemWorld(String worldname) {
        this.worldname = worldname;
        this.w = Bukkit.getWorld((String)worldname);
    }

    public static SystemWorld getSystemWorld(String worldname) {
        Preconditions.checkNotNull((Object)worldname, (Object)"worldname must not be null");
        if (cached.containsKey(worldname)) {
            return cached.get(worldname);
        }
        SystemWorld sw = new SystemWorld(worldname);
        if (sw != null && sw.exists()) {
            cached.put(worldname, sw);
            return sw;
        }
        return null;
    }

    public static void tryUnloadLater(World w) {
        if (w != null) {
            Bukkit.getScheduler().runTaskLater((Plugin)WorldSystem.getInstance(), () -> {
                SystemWorld sw;
                if (w.getPlayers().size() == 0 && (sw = SystemWorld.getSystemWorld(w.getName())) != null && sw.isLoaded()) {
                    sw.unloadLater(w);
                }
            }, 20L);
        }
    }

    public static boolean create(Player p, WorldTemplate template) {
        return SystemWorld.create(p.getUniqueId(), template);
    }

    public static boolean create(UUID uniqueID, WorldTemplate template) {
        DependenceConfig dc = new DependenceConfig(uniqueID);
        String uuid = uniqueID.toString();
        int id = DependenceConfig.getHighestID() + 1;
        String worldname = "ID" + id + "-" + uuid;
        final Player p = Bukkit.getPlayer((UUID)uniqueID);
        WorldCreator creator = template.generatorSettings.asWorldCreator(worldname);
        final WorldCreateEvent event = new WorldCreateEvent(uniqueID, creator);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        dc.createNewEntry();
        String worlddir = PluginConfig.getWorlddir();
        File exampleworld = new File(template.getPath());
        if (new File(template.getPath() + "/uid.dat").exists()) {
            new File(template.getPath() + "/uid.dat").delete();
        }
        File newworld = new File(worlddir + "/" + worldname);
        if (exampleworld.isDirectory()) {
            try {
                FileUtils.copyDirectory((File)exampleworld, (File)newworld);
            }
            catch (IOException e) {
                System.err.println("Couldn't create world for " + uuid);
                e.printStackTrace();
            }
        } else {
            newworld.mkdirs();
        }
        WorldConfig.create(uniqueID, template);
        File world = new File(worlddir + "/" + worldname);
        if (!world.exists()) {
            world = new File(Bukkit.getWorldContainer(), worldname);
        } else {
            if (new File(Bukkit.getWorldContainer(), worldname).exists() && new File(PluginConfig.getWorlddir() + "/" + worldname).exists()) {
                try {
                    FileUtils.deleteDirectory((File)new File(Bukkit.getWorldContainer(), worldname));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                FileUtils.moveDirectoryToDirectory((File)world, (File)Bukkit.getWorldContainer(), (boolean)false);
            }
            catch (IOException e) {
                if (p != null && p.isOnline()) {
                    p.sendMessage(PluginConfig.getPrefix() + "\u00a7cError: " + e.getMessage());
                }
                System.err.println("Couldn't load world of " + uuid);
                e.printStackTrace();
                return false;
            }
        }
        final SystemWorld sw = SystemWorld.getSystemWorld(worldname);
        sw.setCreating(true);
        new BukkitRunnable(){

            public void run() {
                WorldSystem.getInstance().getAdapter().create(event.getWorldCreator(), sw, () -> new BukkitRunnable(){

                    public void run() {
                        if (p != null && p.isOnline()) {
                            p.sendMessage(MessageConfig.getWorldCreated());
                            SettingsConfig.getCommandsonGet().stream().map(s -> s.replace("%player", p.getName()).replace("%world", sw.getName()).replace("%uuid", p.getUniqueId().toString())).forEach(s -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)s));
                        }
                    }
                }.runTask((Plugin)WorldSystem.getInstance()));
            }
        }.runTaskLater((Plugin)WorldSystem.getInstance(), 1L);
        return true;
    }

    public void directUnload(World w) {
        if (!Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTask((Plugin)WorldSystem.getInstance(), () -> this.directUnload(w));
            return;
        }
        Preconditions.checkNotNull((Object)w, (Object)"world must not be null");
        this.setUnloading(true);
        w.save();
        for (Chunk c : w.getLoadedChunks()) {
            c.unload();
        }
        WorldConfig config = WorldConfig.getWorldConfig(this.worldname);
        for (Player a : w.getPlayers()) {
            PlayerPositions.instance.saveWorldsPlayerLocation(a, config);
            a.teleport(PluginConfig.getSpawn(a));
            a.setGameMode(PluginConfig.getSpawnGamemode());
        }
        if (this.unloading && Bukkit.unloadWorld((World)w, (boolean)true)) {
            File worldinserver = new File(Bukkit.getWorldContainer(), this.worldname);
            File worlddir = new File(PluginConfig.getWorlddir());
            try {
                FileUtils.moveDirectoryToDirectory((File)worldinserver, (File)worlddir, (boolean)false);
                Bukkit.getWorlds().remove(w);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void unloadLater(World w) {
        if (!Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTask((Plugin)WorldSystem.getInstance(), () -> this.unloadLater(w));
            return;
        }
        if (this.unloading) {
            return;
        }
        Preconditions.checkNotNull((Object)w, (Object)"world must not be null");
        WorldUnloadEvent event = new WorldUnloadEvent(this);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.setUnloading(true);
        w.save();
        for (Chunk c : w.getLoadedChunks()) {
            c.unload();
        }
        for (Player a : w.getPlayers()) {
            a.teleport(PluginConfig.getSpawn(a));
            a.setGameMode(PluginConfig.getSpawnGamemode());
        }
        this.unloadLaterTask = Bukkit.getScheduler().runTaskLater((Plugin)WorldSystem.getInstance(), () -> {
            if (this.unloading && w.getPlayers().size() == 0 && Bukkit.unloadWorld((World)w, (boolean)true)) {
                File worldinserver = new File(Bukkit.getWorldContainer(), this.worldname);
                File worlddir = new File(PluginConfig.getWorlddir());
                try {
                    FileUtils.moveDirectoryToDirectory((File)worldinserver, (File)worlddir, (boolean)false);
                    Bukkit.getWorlds().remove(w);
                    this.setUnloading(false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, (long)(20 * PluginConfig.getUnloadingTime()));
    }

    public void load(final Player p) {
        World w;
        if (!Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTask((Plugin)WorldSystem.getInstance(), () -> this.load(p));
            return;
        }
        Preconditions.checkNotNull((Object)p, (Object)"player must not be null");
        Preconditions.checkArgument((boolean)p.isOnline(), (Object)"player must be online");
        if (this.creating) {
            p.sendMessage(MessageConfig.getWorldStillCreating());
            return;
        }
        WorldLoadEvent event = new WorldLoadEvent(p, this);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.setUnloading(false);
        p.sendMessage(MessageConfig.getSettingUpWorld());
        String worlddir = PluginConfig.getWorlddir();
        File world = new File(worlddir + "/" + this.worldname);
        if (world.exists()) {
            File propablyExistingWorld = new File(Bukkit.getWorldContainer(), this.worldname);
            if (propablyExistingWorld.exists()) {
                System.err.println("World " + this.worldname + " existed twice!");
                try {
                    FileUtils.deleteDirectory((File)propablyExistingWorld);
                }
                catch (IOException e) {
                    p.sendMessage(MessageConfig.getUnknownError());
                    e.printStackTrace();
                }
            }
            try {
                FileUtils.moveDirectoryToDirectory((File)world, (File)Bukkit.getWorldContainer(), (boolean)false);
            }
            catch (IOException e) {
                System.err.println("Couldn't load world of " + p.getName());
                p.sendMessage(PluginConfig.getPrefix() + "\u00a7cError: " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (this.worldname.charAt(this.worldname.length() - 37) == ' ') {
            StringBuilder myName = new StringBuilder(this.worldname);
            myName.setCharAt(this.worldname.length() - 37, '-');
            world.renameTo(new File(Bukkit.getWorldContainer(), myName.toString()));
            this.worldname = myName.toString();
        }
        WorldCreator creator = new WorldCreator(this.worldname);
        String templateKey = WorldConfig.getWorldConfig(this.worldname).getTemplateKey();
        WorldTemplate template = WorldTemplateProvider.getInstance().getTemplate(templateKey);
        if (template == null) {
            template = WorldTemplateProvider.getInstance().getTemplate(PluginConfig.getDefaultWorldTemplate());
        }
        if (template != null) {
            creator = template.generatorSettings.asWorldCreator(this.worldname);
        }
        if ((w = Bukkit.getWorld((String)this.worldname)) == null) {
            w = Bukkit.createWorld((WorldCreator)creator);
        }
        this.w = w;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)WorldSystem.getInstance(), new Runnable(){

            @Override
            public void run() {
                SystemWorld.this.teleportToWorldSpawn(p);
            }
        }, 10L);
        OfflinePlayer owner = PlayerWrapper.getOfflinePlayer(WorldConfig.getWorldConfig(this.worldname).getOwner());
        DependenceConfig dc = new DependenceConfig(owner);
        dc.setLastLoaded();
    }

    public boolean isLoaded() {
        File worldAsDir = new File(Bukkit.getWorldContainer(), this.worldname + "/worldconfig.yml");
        World w = Bukkit.getWorld((String)this.worldname);
        return worldAsDir.exists() && w != null;
    }

    private boolean exists() {
        File worldAsDir = new File(Bukkit.getWorldContainer(), this.worldname + "/worldconfig.yml");
        if (worldAsDir.exists()) {
            return true;
        }
        worldAsDir = new File(PluginConfig.getWorlddir() + "/" + this.worldname + "/worldconfig.yml");
        return worldAsDir.exists();
    }

    public void teleportToWorldSpawn(Player p) {
        Preconditions.checkNotNull((Object)p, (Object)"player must not be null");
        Preconditions.checkArgument((boolean)p.isOnline(), (Object)"player must be online");
        PlayerPositions positions = PlayerPositions.instance;
        if (this.creating) {
            p.sendMessage(MessageConfig.getWorldStillCreating());
            return;
        }
        this.setUnloading(false);
        this.w = Bukkit.getWorld((String)this.worldname);
        if (this.w == null) {
            return;
        }
        WorldConfig config = WorldConfig.getWorldConfig(this.worldname);
        if (config.getHome() != null) {
            p.teleport(positions.injectWorldsLocation(p, config, config.getHome()));
        } else if (PluginConfig.useWorldSpawn()) {
            p.teleport(positions.injectWorldsLocation(p, config, PluginConfig.getWorldSpawn(this.w)));
        } else {
            p.teleport(positions.injectWorldsLocation(p, config, this.w.getSpawnLocation()));
        }
        if (PluginConfig.isSurvival()) {
            p.setGameMode(GameMode.SURVIVAL);
        } else {
            p.setGameMode(GameMode.CREATIVE);
        }
        OfflinePlayer owner = PlayerWrapper.getOfflinePlayer(WorldConfig.getWorldConfig(this.worldname).getOwner());
        DependenceConfig dc = new DependenceConfig(owner);
        dc.setLastLoaded();
    }

    public World getWorld() {
        return this.w;
    }

    public boolean isCreating() {
        return this.creating;
    }

    public void setCreating(boolean creating) {
        this.creating = creating;
    }

    public void setUnloading(boolean unloading) {
        this.unloading = unloading;
        if (!unloading && this.unloadLaterTask != null && !VersionUtil.isCancelled(this.unloadLaterTask)) {
            this.unloadLaterTask.cancel();
        }
    }

    public String getName() {
        return this.worldname;
    }
}

