/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.util.database;

import de.butzlabben.world.util.database.DatabaseUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class DatabaseConnection
implements DatabaseUtil {
    final Object lock = new Object();
    Connection connection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.connection == null || this.connection.isClosed()) {
                    System.err.println("[WorldSystem | DB] Connection does not exist or was already closed");
                    return;
                }
                this.connection.close();
            }
            catch (SQLException e) {
                System.out.println("[WorldSystem | DB] Connection could not be closed");
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.connection == null || this.connection.isClosed()) {
                this.connect();
            }
            return this.connection.prepareStatement(sql, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(PreparedStatement ps) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.connection == null || this.connection.isClosed()) {
                this.connect();
            }
            return ps.executeQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(PreparedStatement ps) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.connection == null || this.connection.isClosed()) {
                this.connect();
            }
            return ps.executeUpdate();
        }
    }

    @Override
    public boolean isConnectionAvailable() {
        return this.connection != null;
    }

    public Connection getConnection() {
        return this.connection;
    }
}

