/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.util;

import de.butzlabben.WorldSystem;
import de.butzlabben.world.config.DependenceConfig;
import de.butzlabben.world.config.WorldConfig;
import de.butzlabben.world.wrapper.SystemWorld;
import de.butzlabben.world.wrapper.WorldPlayer;
import java.util.Objects;
import java.util.UUID;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class PapiExtension
extends PlaceholderExpansion {
    private final WorldSystem worldSystem = WorldSystem.getInstance();

    public String getIdentifier() {
        return "worldsystem";
    }

    public String getAuthor() {
        return "Butzlabben";
    }

    public String getVersion() {
        return this.worldSystem.getDescription().getVersion();
    }

    public String onRequest(OfflinePlayer p, String params) {
        DependenceConfig config = new DependenceConfig(p);
        switch (params) {
            case "has_world": {
                return "" + new DependenceConfig(p).hasWorld();
            }
            case "is_creator": {
                WorldPlayer player = new WorldPlayer(Objects.requireNonNull(Bukkit.getPlayer((UUID)p.getUniqueId())));
                if (!player.isOnSystemWorld()) {
                    return "false";
                }
                return "" + player.isOwnerofWorld();
            }
            case "world_name_of_player": {
                if (!config.hasWorld()) {
                    return "none";
                }
                return config.getWorldname();
            }
            case "world_of_player_loaded": {
                if (!config.hasWorld()) {
                    return "none";
                }
                return "" + SystemWorld.getSystemWorld(config.getWorldname()).isLoaded();
            }
            case "pretty_world_name": {
                if (!p.isOnline()) {
                    if (!config.hasWorld()) {
                        Player p1 = p.getPlayer();
                        if (p1 != null && p1.isOnline()) {
                            return p1.getLocation().getWorld().getName();
                        }
                        return "none";
                    }
                    return config.getOwner().getName();
                }
                World world = ((Player)p).getWorld();
                if (WorldConfig.exists(world.getName())) {
                    return WorldConfig.getWorldConfig(world.getName()).getOwnerName();
                }
                return world.getName();
            }
        }
        throw new IllegalArgumentException("No placeholder named\"" + this.getIdentifier() + "_" + params + "\" is known");
    }
}

