/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.util;

import com.google.common.base.Preconditions;
import de.butzlabben.world.config.PluginConfig;
import de.butzlabben.world.util.PlayerWrapper;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;

public class MoneyUtil {
    private static Object economy = null;

    private MoneyUtil() {
    }

    public static void removeMoney(UUID uuid, int money) {
        Preconditions.checkNotNull((Object)uuid);
        Preconditions.checkNotNull((Object)economy);
        Preconditions.checkArgument((money > 0 ? 1 : 0) != 0, (Object)"Money must not be negative");
        OfflinePlayer op = PlayerWrapper.getOfflinePlayer(uuid);
        Economy economy = (Economy)MoneyUtil.economy;
        EconomyResponse response = economy.withdrawPlayer(op, (double)money);
        if (!response.transactionSuccess()) {
            Bukkit.getConsoleSender().sendMessage(PluginConfig.getPrefix() + "\u00a7cTransaction failure for removing " + money + " from " + op.getName());
            Bukkit.getConsoleSender().sendMessage(PluginConfig.getPrefix() + "\u00a7cError message: " + response.errorMessage);
        }
    }

    public static boolean hasMoney(UUID uuid, int money) {
        Preconditions.checkNotNull((Object)uuid);
        Preconditions.checkNotNull((Object)economy);
        Preconditions.checkArgument((money > 0 ? 1 : 0) != 0, (Object)"Money must not be negative");
        OfflinePlayer op = PlayerWrapper.getOfflinePlayer(uuid);
        Economy economy = (Economy)MoneyUtil.economy;
        return economy.getBalance(op) >= (double)money;
    }

    static {
        if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
            try {
                RegisteredServiceProvider service = Bukkit.getServicesManager().getRegistration(Economy.class);
                if (service != null) {
                    economy = service.getProvider();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (economy == null) {
            Bukkit.getConsoleSender().sendMessage(PluginConfig.getPrefix() + "Couldn't find a Vault Economy extension");
        }
    }
}

