/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.listener;

import de.butzlabben.world.config.MessageConfig;
import de.butzlabben.world.config.WorldConfig;
import de.butzlabben.world.config.WorldPerm;
import de.butzlabben.world.wrapper.WorldPlayer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class WorldEditListener
implements Listener {
    private final List<String> worldEditCommands = new ArrayList<String>();

    public WorldEditListener() {
        try {
            String packageName = Bukkit.getServer().getClass().getPackage().getName();
            String version = packageName.substring(packageName.lastIndexOf(".") + 1);
            Class<?> serverClass = Class.forName("org.bukkit.craftbukkit." + version + ".CraftServer");
            Field f1 = serverClass.getDeclaredField("commandMap");
            f1.setAccessible(true);
            SimpleCommandMap commandMap = (SimpleCommandMap)f1.get(Bukkit.getServer());
            Field f2 = SimpleCommandMap.class.getDeclaredField("knownCommands");
            f2.setAccessible(true);
            Map knownCommands = (Map)f2.get(commandMap);
            this.worldEditCommands.addAll(knownCommands.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains("worldedit")).map(entry -> ((Command)entry.getValue()).getName()).collect(Collectors.toList()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public void playerCommandHandler(PlayerCommandPreprocessEvent event) {
        WorldConfig wc;
        String worldname;
        String command = event.getMessage().split(" ")[0];
        if (!this.isWorldEditCommand(command)) {
            return;
        }
        Player p = event.getPlayer();
        WorldPlayer wp = new WorldPlayer((OfflinePlayer)p, worldname = p.getWorld().getName());
        if (wp.isOnSystemWorld() && !wp.isOwnerofWorld() && !p.hasPermission(WorldPerm.WORLDEDIT.getOpPerm()) && !(wc = WorldConfig.getWorldConfig(p.getWorld().getName())).hasPermission(p.getUniqueId(), WorldPerm.WORLDEDIT)) {
            p.sendMessage(MessageConfig.getNoPermission());
            event.setCancelled(true);
        }
    }

    private boolean isWorldEditCommand(String command) {
        System.out.println(command);
        return this.worldEditCommands.contains(command) || this.worldEditCommands.contains(command.replaceFirst("/", "")) || this.worldEditCommands.contains(command.replaceFirst("/worldedit:", ""));
    }
}

