/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.gui;

import de.butzlabben.inventory.OrcClickListener;
import de.butzlabben.inventory.OrcInventory;
import de.butzlabben.inventory.OrcItem;
import de.butzlabben.world.config.GuiConfig;
import de.butzlabben.world.config.WorldConfig;
import de.butzlabben.world.gui.PlayersPageGUI;
import de.butzlabben.world.gui.WorldOptionsGUI;
import de.butzlabben.world.gui.clicklistener.InventoryOpenClickListener;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class WorldSystemGUI
extends OrcInventory {
    private static final String path = "worldsystem.";

    public WorldSystemGUI() {
        super(GuiConfig.getTitle((FileConfiguration)GuiConfig.getConfig(), "worldsystem"), GuiConfig.getRows("worldsystem"), GuiConfig.isFill("worldsystem"));
        this.loadItem("playeroptions", (p, inv, item) -> {
            p.closeInventory();
            PlayersPageGUI.openGUI(p);
        });
        this.loadItem("worldoptions", new InventoryOpenClickListener(new WorldOptionsGUI()));
        if (GuiConfig.isEnabled("worldsystem.back")) {
            OrcItem back = OrcItem.back.clone();
            back.setOnClick((p, inv, item) -> p.closeInventory());
            this.addItem(GuiConfig.getSlot("worldsystem.back"), back);
        }
    }

    @Override
    public Inventory getInventory(Player player) {
        PlayersPageGUI.preloadPlayers(WorldConfig.getWorldConfig(player.getWorld().getName()));
        return super.getInventory(player);
    }

    public void loadItem(String subpath, OrcClickListener listener) {
        if (!GuiConfig.isEnabled(path + subpath)) {
            return;
        }
        OrcItem item = GuiConfig.getItem(path + subpath);
        if (item != null) {
            item.setOnClick(listener);
            this.addItem(GuiConfig.getSlot(path + subpath), item);
        }
    }

    public void loadItem(String subpath) {
        this.loadItem(subpath, null);
    }

    public boolean canOpen(Player p) {
        return true;
    }
}

