/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.gui;

import de.butzlabben.inventory.OrcClickListener;
import de.butzlabben.inventory.OrcInventory;
import de.butzlabben.inventory.OrcItem;
import de.butzlabben.world.config.GuiConfig;
import de.butzlabben.world.wrapper.WorldTemplate;
import de.butzlabben.world.wrapper.WorldTemplateProvider;
import java.util.function.Consumer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class WorldChooseGUI
extends OrcInventory {
    private static final String path = "worldchoose.";

    public WorldChooseGUI() {
        this((Consumer<WorldTemplate>)null, (Player)null);
    }

    public WorldChooseGUI(Player player) {
        this(null, player);
    }

    public WorldChooseGUI(Consumer<WorldTemplate> onClick, Player player) {
        super(GuiConfig.getTitle((FileConfiguration)GuiConfig.getConfig(), "worldchoose"), GuiConfig.getRows("worldchoose"), GuiConfig.isFill("worldchoose"));
        for (WorldTemplate template : WorldTemplateProvider.getInstance().getTemplates()) {
            if (template.getPermission() != null && !player.hasPermission(template.getPermission())) continue;
            OrcItem icon = template.getIcon();
            if (onClick != null) {
                icon.setOnClick((p, inv, item) -> {
                    p.closeInventory();
                    onClick.accept(template);
                });
            }
            int slot = template.getSlot();
            this.addItem(slot, icon);
        }
        if (GuiConfig.isEnabled("worldchoose.back")) {
            OrcItem back = OrcItem.back.clone();
            back.setOnClick((p, inv, item) -> p.closeInventory());
            this.addItem(GuiConfig.getSlot("worldchoose.back"), back);
        }
    }

    public static void letChoose(Player player, Consumer<WorldTemplate> template) {
        player.openInventory(new WorldChooseGUI(template, player).getInventory(player));
    }

    public static void letChoose(Player player) {
        player.openInventory(new WorldChooseGUI(player).getInventory(player));
    }

    public void loadItem(String subpath, OrcClickListener listener) {
        if (!GuiConfig.isEnabled(path + subpath)) {
            return;
        }
        OrcItem item = GuiConfig.getItem(path + subpath);
        if (item != null) {
            item.setOnClick(listener);
            this.addItem(GuiConfig.getSlot(path + subpath), item);
        }
    }

    public void loadItem(String subpath) {
        this.loadItem(subpath, null);
    }

    public boolean canOpen(Player p) {
        return true;
    }
}

