/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.gui;

import de.butzlabben.inventory.DependListener;
import de.butzlabben.inventory.OrcInventory;
import de.butzlabben.inventory.OrcItem;
import de.butzlabben.world.config.GuiConfig;
import de.butzlabben.world.gui.PlayersPageGUI;
import de.butzlabben.world.gui.clicklistener.ComingSoonClickListener;
import de.butzlabben.world.gui.clicklistener.CommandExecutorClickListener;
import de.butzlabben.world.gui.playeroption.BuildStatus;
import de.butzlabben.world.gui.playeroption.GamemodeStatus;
import de.butzlabben.world.gui.playeroption.TeleportStatus;
import de.butzlabben.world.gui.playeroption.WorldEditStatus;
import de.butzlabben.world.util.PlayerWrapper;
import de.butzlabben.world.wrapper.WorldPlayer;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class PlayerOptionsGUI
extends OrcInventory {
    private static final String path = "options.player.";

    public PlayerOptionsGUI(Player loader, String otherPlayer, UUID other) {
        super(GuiConfig.getTitle((FileConfiguration)GuiConfig.getConfig(), "options.player").replace("%player", otherPlayer), GuiConfig.getRows("options.player"), GuiConfig.isFill("options.player"));
        WorldPlayer wp = new WorldPlayer(PlayerWrapper.getOfflinePlayer(other), loader.getWorld().getName());
        this.loadItem("build", "/ws togglebuild " + otherPlayer, new BuildStatus(wp));
        this.loadItem("gamemode", "/ws togglegm " + otherPlayer, new GamemodeStatus(wp));
        this.loadItem("teleport", "/ws toggletp " + otherPlayer, new TeleportStatus(wp));
        this.loadItem("worldedit", "/ws togglewe " + otherPlayer, new WorldEditStatus(wp));
        this.loadItem("time");
        this.loadItem("addmember");
        this.loadItem("delmember");
        this.loadItem("setpermissions");
        this.loadItem("administrateworld");
        if (GuiConfig.isEnabled("options.player.back")) {
            OrcItem back = OrcItem.back.clone();
            back.setOnClick((p, inv, i) -> {
                p.closeInventory();
                PlayersPageGUI.openGUI(p);
            });
            this.addItem(GuiConfig.getSlot("options.player.back"), back);
        }
    }

    public void loadItem(String subpath, String message, DependListener depend) {
        if (!GuiConfig.isEnabled(path + subpath)) {
            return;
        }
        OrcItem item = GuiConfig.getItem(path + subpath);
        if (item != null) {
            if (message == null) {
                item.setOnClick(new ComingSoonClickListener());
            } else {
                item.setOnClick(new CommandExecutorClickListener(message));
            }
            this.addItem(GuiConfig.getSlot(path + subpath), item);
            if (depend == null) {
                this.addItem(GuiConfig.getState(path + subpath), OrcItem.coming_soon.clone());
            } else {
                this.addItem(GuiConfig.getState(path + subpath), OrcItem.disabled.clone().setDepend(depend));
            }
        }
    }

    public void loadItem(String subpath, String message) {
        this.loadItem(subpath, message, null);
    }

    public void loadItem(String subpath) {
        this.loadItem(subpath, null);
    }
}

