/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.data;

import com.google.gson.Gson;
import de.butzlabben.world.data.objects.WorldSystemData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;

public class WorldDatabase {
    private static WorldSystemData wsDataBase;
    private String dbFilePath;

    public WorldDatabase(String databaseFilePath) {
        this.dbFilePath = databaseFilePath;
        wsDataBase = this.getWorldSystemDatabase();
    }

    public int getPlayerCount() {
        return wsDataBase.getPlayers();
    }

    public void addPlayer(String playerUUID) {
        wsDataBase.addplayer(playerUUID);
        this.saveWSData();
    }

    private WorldSystemData getWorldSystemDatabase() {
        File wsDataFile = new File(this.dbFilePath);
        Gson gson = new Gson();
        WorldSystemData newDatabase = null;
        if (!wsDataFile.exists()) {
            newDatabase = new WorldSystemData();
            this.saveWSData();
            return newDatabase;
        }
        try {
            BufferedReader reader = Files.newBufferedReader(Paths.get(this.dbFilePath, new String[0]));
            newDatabase = (WorldSystemData)gson.fromJson((Reader)reader, WorldSystemData.class);
            ((Reader)reader).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (newDatabase == null) {
            newDatabase = new WorldSystemData();
        }
        return newDatabase;
    }

    private void saveWSData() {
        Gson gson = new Gson();
        File dataFile = new File(this.dbFilePath);
        if (!dataFile.exists()) {
            try {
                dataFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            FileWriter writer = new FileWriter(dataFile);
            gson.toJson((Object)wsDataBase, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

