/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.config;

import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import de.butzlabben.world.GameProfileBuilder;
import de.butzlabben.world.config.DependenceConfig;
import de.butzlabben.world.config.PluginConfig;
import de.butzlabben.world.config.WorldPerm;
import de.butzlabben.world.util.PlayerWrapper;
import de.butzlabben.world.wrapper.WorldTemplate;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class WorldConfig {
    private static final HashMap<String, WorldConfig> instances = new HashMap();
    private final UUID owner;
    private final int id;
    private final HashMap<UUID, HashSet<WorldPerm>> permissions = new HashMap();
    private String ownerName;
    private String templateKey;
    private boolean fire;
    private boolean tnt;
    public Location home = null;

    private WorldConfig(String worldname) {
        if (!WorldConfig.exists(worldname)) {
            throw new IllegalArgumentException("WorldConfig doesn't exist");
        }
        this.owner = UUID.fromString(worldname.substring(worldname.length() - 36));
        this.id = Integer.parseInt(worldname.split("-")[0].substring(2));
    }

    public static File getWorldFile(String worldname) {
        File worldconfig = new File(Bukkit.getWorldContainer(), worldname + "/worldconfig.yml");
        if (!worldconfig.exists()) {
            worldconfig = new File(PluginConfig.getWorlddir() + "/" + worldname + "/worldconfig.yml");
        }
        if (!worldconfig.exists()) {
            worldconfig = new File(worldname + "/worldconfig.yml");
        }
        return worldconfig;
    }

    public static boolean exists(String worldname) {
        return WorldConfig.getWorldFile(worldname).exists();
    }

    public static WorldConfig getWorldConfig(String worldname) {
        if (!instances.containsKey(worldname)) {
            instances.put(worldname, new WorldConfig(worldname));
        }
        return instances.get(worldname).load();
    }

    public static void create(UUID uuid, WorldTemplate template) {
        DependenceConfig dc = new DependenceConfig(uuid);
        String worldname = dc.getWorldname();
        File file = new File(PluginConfig.getWorlddir() + worldname + "/worldconfig.yml");
        try {
            file.createNewFile();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            System.err.println("Error while creating worldconfig for " + uuid.toString());
        }
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
        cfg.set("Informations.ID", (Object)dc.getID());
        cfg.set("Informations.Owner.PlayerUUID", (Object)uuid.toString());
        cfg.set("Informations.Owner.Actualname", (Object)Objects.requireNonNull(PlayerWrapper.getOfflinePlayer(uuid)).getName());
        cfg.set("Informations.template_key", (Object)template.getName());
        cfg.set("Settings.TNTDamage", (Object)false);
        cfg.set("Settings.Fire", (Object)false);
        cfg.set("Members", null);
        try {
            cfg.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Error while saving worldconfig for " + uuid.toString());
        }
    }

    public boolean addPermission(UUID player, WorldPerm perm) {
        if (this.owner.equals(player)) {
            throw new IllegalArgumentException("Permissions of the owner cannot change");
        }
        HashSet perms = this.permissions.computeIfAbsent(player, k -> new HashSet());
        return perms.add(perm);
    }

    public boolean removePermission(UUID player, WorldPerm perm) {
        if (this.owner.equals(player)) {
            throw new IllegalArgumentException("Permissions of the owner cannot change");
        }
        HashSet<WorldPerm> perms = this.permissions.get(player);
        if (perms == null) {
            return false;
        }
        return perms.remove((Object)perm);
    }

    public boolean removeAllPermissions(UUID player) {
        if (this.owner.equals(player)) {
            throw new IllegalArgumentException("Permissions of the owner cannot change");
        }
        HashSet<WorldPerm> perms = this.permissions.remove(player);
        return perms != null && perms.size() != 0;
    }

    public boolean addAllPermissions(UUID player) {
        if (this.owner.equals(player)) {
            throw new IllegalArgumentException("Permissions of the owner cannot change");
        }
        HashSet perms = this.permissions.computeIfAbsent(player, k -> new HashSet());
        return perms.addAll(Sets.newHashSet((Object[])WorldPerm.values()));
    }

    public boolean hasPermission(UUID player, WorldPerm perm) {
        if (this.owner.equals(player)) {
            return true;
        }
        HashSet<WorldPerm> perms = this.permissions.get(player);
        return perms != null && perms.contains((Object)perm);
    }

    public HashSet<WorldPerm> getPermissions(UUID player) {
        if (this.owner == player) {
            return Sets.newHashSet((Object[])WorldPerm.values());
        }
        HashSet<WorldPerm> perms = this.permissions.get(player);
        if (perms == null) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet(perms);
    }

    public boolean addMember(UUID player) {
        return this.addPermission(player, WorldPerm.MEMBER);
    }

    public boolean addMember(UUID player, UUID target) {
        if (this.hasPermission(player, WorldPerm.EDITMEMBERS)) {
            return this.addMember(target);
        }
        return false;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public boolean isMember(UUID player) {
        return this.hasPermission(player, WorldPerm.MEMBER);
    }

    public boolean removeMember(UUID player) {
        return this.removeAllPermissions(player);
    }

    public boolean removeMember(UUID player, UUID target) {
        if (this.hasPermission(player, WorldPerm.EDITMEMBERS) && !this.hasPermission(player, WorldPerm.EDITMEMBERS)) {
            return this.removeMember(target);
        }
        return false;
    }

    public boolean canBuild(UUID player) {
        return this.hasPermission(player, WorldPerm.BUILD);
    }

    public void setBuild(UUID player, boolean allowed) {
        if (allowed) {
            this.addPermission(player, WorldPerm.BUILD);
        } else {
            this.removePermission(player, WorldPerm.BUILD);
        }
    }

    public boolean setBuild(UUID player, UUID target, boolean allowed) {
        if (!this.isAllowedToAdministrateMember(player, target)) {
            return false;
        }
        this.setBuild(target, allowed);
        return true;
    }

    private boolean isAllowedToAdministrateMember(UUID player, UUID target) {
        return target != this.owner && player != target && this.hasPermission(player, WorldPerm.ADMINISTRATEMEMBERS) && this.hasPermission(player, WorldPerm.ADMINISTRATEMEMBERS);
    }

    public boolean canGamemode(UUID player) {
        return this.hasPermission(player, WorldPerm.GAMEMODE);
    }

    public void setGamemode(UUID player, boolean allowed) {
        if (allowed) {
            this.addPermission(player, WorldPerm.GAMEMODE);
        } else {
            this.removePermission(player, WorldPerm.GAMEMODE);
        }
    }

    public boolean setGamemode(UUID player, UUID target, boolean allowed) {
        if (!this.isAllowedToAdministrateMember(player, target)) {
            return false;
        }
        this.setGamemode(target, allowed);
        return true;
    }

    public boolean canTeleport(UUID player) {
        return this.hasPermission(player, WorldPerm.TELEPORT);
    }

    public void setTeleport(UUID player, boolean allowed) {
        if (allowed) {
            this.addPermission(player, WorldPerm.TELEPORT);
        } else {
            this.removePermission(player, WorldPerm.TELEPORT);
        }
    }

    public boolean setTeleport(UUID player, UUID target, boolean allowed) {
        if (!this.isAllowedToAdministrateMember(player, target)) {
            return false;
        }
        this.setTeleport(target, allowed);
        return true;
    }

    public HashSet<UUID> getMembers() {
        return Sets.newHashSet(this.permissions.keySet());
    }

    public HashMap<UUID, String> getMembersWithNames() {
        HashMap<UUID, String> map = new HashMap<UUID, String>();
        for (UUID uuid : this.permissions.keySet()) {
            OfflinePlayer op = PlayerWrapper.getOfflinePlayer(uuid);
            if (op == null || op.getName() == null) {
                if (!PluginConfig.contactAuth()) continue;
                try {
                    GameProfile prof = GameProfileBuilder.fetch(uuid);
                    map.put(uuid, prof.getName());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            map.put(uuid, op.getName());
        }
        return map;
    }

    public WorldConfig save() throws IOException {
        File file = WorldConfig.getWorldFile(this.getWorldName());
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
        cfg.set("Informations.ID", (Object)this.id);
        cfg.set("Informations.Owner.Actualname", (Object)this.ownerName);
        cfg.set("Informations.Owner.PlayerUUID", (Object)this.owner.toString());
        cfg.set("Informations.template_key", (Object)this.templateKey);
        cfg.set("Settings.TNTDamage", (Object)this.tnt);
        cfg.set("Settings.Fire", (Object)this.fire);
        if (this.home != null) {
            cfg.set("Settings.home.x", (Object)this.home.getX());
            cfg.set("Settings.home.y", (Object)this.home.getY());
            cfg.set("Settings.home.z", (Object)this.home.getZ());
            cfg.set("Settings.home.yaw", (Object)Float.valueOf(this.home.getYaw()));
            cfg.set("Settings.home.pitch", (Object)Float.valueOf(this.home.getPitch()));
        } else {
            cfg.set("Settings.home", null);
        }
        cfg.set("Members", null);
        for (Map.Entry<UUID, HashSet<WorldPerm>> entry : this.permissions.entrySet()) {
            ArrayList<String> array = new ArrayList<String>(entry.getValue().size());
            for (WorldPerm perm : entry.getValue()) {
                array.add(perm.name());
            }
            cfg.set("Members." + entry.getKey(), array);
        }
        cfg.save(file);
        return this;
    }

    private String getWorldName() {
        return "ID" + this.id + "-" + this.owner;
    }

    public WorldConfig load() {
        File file = WorldConfig.getWorldFile(this.getWorldName());
        this.permissions.clear();
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)file);
        this.ownerName = cfg.getString("Informations.Owner.Actualname", "Unknown Playername");
        this.templateKey = cfg.getString("Informations.template_key");
        this.tnt = cfg.getBoolean("Settings.TNTDamage", true);
        this.fire = cfg.getBoolean("Settings.Fire", true);
        if (cfg.isSet("Settings.home")) {
            this.home = new Location(null, cfg.getDouble("Settings.home.x"), cfg.getDouble("Settings.home.y"), cfg.getDouble("Settings.home.z"), (float)cfg.getDouble("Settings.home.yaw"), (float)cfg.getDouble("Settings.home.pitch"));
        }
        if (this.membersOldFormatted(cfg)) {
            for (String s : cfg.getConfigurationSection("Members").getKeys(false)) {
                HashSet<WorldPerm> perms = new HashSet<WorldPerm>();
                perms.add(WorldPerm.MEMBER);
                if (cfg.getBoolean("Members." + s + ".Permissions.CanBuild")) {
                    perms.add(WorldPerm.BUILD);
                }
                if (cfg.getBoolean("Members." + s + ".Permissions.CanTP")) {
                    perms.add(WorldPerm.TELEPORT);
                }
                if (cfg.getBoolean("Members." + s + ".Permissions.CanBuild")) {
                    perms.add(WorldPerm.GAMEMODE);
                }
                this.permissions.put(UUID.fromString(s), perms);
            }
            try {
                this.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ConfigurationSection section = cfg.getConfigurationSection("Members");
            if (section != null) {
                for (String suuid : section.getKeys(false)) {
                    UUID uuid = UUID.fromString(suuid);
                    List list = section.getStringList(suuid);
                    HashSet<WorldPerm> perms = new HashSet<WorldPerm>(list.size());
                    for (String perm : list) {
                        perms.add(WorldPerm.valueOf(perm));
                    }
                    this.permissions.put(uuid, perms);
                }
            }
        }
        return this;
    }

    private boolean membersOldFormatted(YamlConfiguration cfg) {
        if (cfg.getConfigurationSection("Members") == null) {
            return false;
        }
        String name = cfg.getString("Members." + (String)cfg.getConfigurationSection("Members").getKeys(false).iterator().next() + ".Actualname");
        return name != null;
    }

    public Location getHome() {
        if (this.home == null) {
            return null;
        }
        return new Location(Bukkit.getWorld((String)this.getWorldName()), this.home.getX(), this.home.getY(), this.home.getZ(), this.home.getYaw(), this.home.getPitch());
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public boolean isFire() {
        return this.fire;
    }

    public void setFire(boolean fire) {
        this.fire = fire;
    }

    public boolean setFire(UUID player, boolean fire) {
        if (!this.hasPermission(player, WorldPerm.ADMINISTRATEWORLD)) {
            return false;
        }
        this.setFire(fire);
        return true;
    }

    public boolean isTnt() {
        return this.tnt;
    }

    public void setTnt(boolean tnt) {
        this.tnt = tnt;
    }

    public boolean setTnt(UUID player, boolean tnt) {
        if (!this.hasPermission(player, WorldPerm.ADMINISTRATEWORLD)) {
            return false;
        }
        this.setTnt(tnt);
        return true;
    }

    public int getId() {
        return this.id;
    }

    public void setWorldEdit(UUID player, boolean allowed) {
        if (allowed) {
            this.addPermission(player, WorldPerm.WORLDEDIT);
        } else {
            this.removePermission(player, WorldPerm.WORLDEDIT);
        }
    }

    public boolean setWorldEdit(UUID player, UUID target, boolean allowed) {
        if (!this.isAllowedToAdministrateMember(player, target)) {
            return false;
        }
        this.setWorldEdit(target, allowed);
        return true;
    }

    public boolean canWorldEdit(UUID player) {
        return this.hasPermission(player, WorldPerm.WORLDEDIT);
    }

    public String getTemplateKey() {
        return this.templateKey;
    }

    public void setTemplateKey(String templateKey) {
        this.templateKey = templateKey;
    }
}

