/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.config;

import de.butzlabben.WorldSystem;
import de.butzlabben.world.util.PlayerPositions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginConfig {
    private static final GameMode[] gameModes = new GameMode[]{GameMode.SURVIVAL, GameMode.CREATIVE, GameMode.ADVENTURE, GameMode.SPECTATOR};
    private static File file;

    private PluginConfig() {
    }

    public static void checkConfig(File f) {
        file = f;
        if (file.exists()) {
            YamlConfiguration cfg = PluginConfig.getConfig();
            if (!cfg.isString("worldfolder") || !cfg.isInt("unloadingtime") || !cfg.isBoolean("survival") || !cfg.isString("language") || !cfg.isString("prefix") || !cfg.isInt("request_expires") || !cfg.isBoolean("need_confirm") || !cfg.isBoolean("contact_authserver") || !cfg.isBoolean("spawn_teleportation") || !cfg.isInt("delete_after") || !cfg.isBoolean("worldtemplates.multi_choose") || !cfg.isString("worldtemplates.default") || !cfg.isBoolean("load_worlds_async") || !cfg.isString("database.type") || !cfg.isString("database.worlds_table_name") || !cfg.isString("database.players_table_name") || !cfg.isString("database.mysql_settings.host") || !cfg.isInt("database.mysql_settings.port") || !cfg.isString("database.mysql_settings.username") || !cfg.isString("database.mysql_settings.password") || !cfg.isString("database.mysql_settings.database") || !cfg.isString("database.sqlite_settings.file") || !cfg.isInt("lagsystem.period_in_seconds") || !cfg.isInt("lagsystem.entities_per_world") || !cfg.isBoolean("lagsystem.garbagecollector.use") || !cfg.isInt("lagsystem.garbagecollector.period_in_minutes") || !cfg.isString("spawn.spawnpoint.world") || !cfg.isInt("spawn.gamemode") || !cfg.isBoolean("spawn.spawnpoint.use_last_location") || !cfg.isDouble("spawn.spawnpoint.x") && !cfg.isInt("spawn.spawnpoint.x") || !cfg.isDouble("spawn.spawnpoint.y") && !cfg.isInt("spawn.spawnpoint.y") || !cfg.isDouble("spawn.spawnpoint.z") && !cfg.isInt("spawn.spawnpoint.z") || !cfg.isDouble("spawn.spawnpoint.yaw") && !cfg.isInt("spawn.spawnpoint.yaw") || !cfg.isDouble("spawn.spawnpoint.pitch") && !cfg.isInt("spawn.spawnpoint.pitch") || !cfg.isBoolean("worldspawn.use") || !cfg.isBoolean("worldspawn.use_last_location") || !cfg.isDouble("worldspawn.spawnpoint.x") && !cfg.isInt("worldspawn.spawnpoint.x") || !cfg.isDouble("worldspawn.spawnpoint.y") && !cfg.isInt("worldspawn.spawnpoint.y") || !cfg.isDouble("worldspawn.spawnpoint.z") && !cfg.isInt("worldspawn.spawnpoint.z") || !cfg.isDouble("worldspawn.spawnpoint.yaw") && !cfg.isInt("worldspawn.spawnpoint.yaw") || !cfg.isDouble("worldspawn.spawnpoint.pitch") && !cfg.isInt("worldspawn.spawnpoint.pitch")) {
                try {
                    Files.copy(file.toPath(), new File(file.getParentFile(), "config-broken-" + new SimpleDateFormat("dd-MM-yyyy-HH-mm-ss").format(new Date()) + ".yml").toPath(), StandardCopyOption.REPLACE_EXISTING);
                    Files.delete(file.toPath());
                    System.err.println("[WorldSystem] Config is broken, creating a new one!");
                    PluginConfig.checkConfig(f);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                InputStream in = ((WorldSystem)JavaPlugin.getPlugin(WorldSystem.class)).getResource("config.yml");
                Files.copy(in, file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                System.err.println("Wasn't able to create Config");
                e.printStackTrace();
            }
        }
        if (PluginConfig.getSpawn(null).getWorld() == null) {
            Bukkit.getConsoleSender().sendMessage(PluginConfig.getPrefix() + "\u00a7cWorld is null in spawn.world!");
        }
    }

    public static YamlConfiguration getConfig() {
        try {
            return YamlConfiguration.loadConfiguration((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new IllegalStateException("Cannot access config file");
        }
    }

    public static int getGCPeriod() {
        return PluginConfig.getConfig().getInt("lagsystem.garbagecollector.period_in_minutes", 5);
    }

    public static boolean useGC() {
        return PluginConfig.getConfig().getBoolean("lagsystem.garbagecollector.use", false);
    }

    public static int getEntitysPerWorld() {
        return PluginConfig.getConfig().getInt("lagsystem.entities_per_world", 350);
    }

    public static int getLagCheckPeriod() {
        return PluginConfig.getConfig().getInt("lagsystem.period_in_seconds", 10);
    }

    public static boolean useWorldSpawn() {
        return PluginConfig.getConfig().getBoolean("worldspawn.use", true);
    }

    public static boolean isSurvival() {
        return PluginConfig.getConfig().getBoolean("survival", false);
    }

    public static int getUnloadingTime() {
        return PluginConfig.getConfig().getInt("unloadingtime", 20);
    }

    public static GameMode getSpawnGamemode() {
        return gameModes[PluginConfig.getConfig().getInt("spawn.gamemode", 2)];
    }

    public static String getWorlddir() {
        return PluginConfig.getConfig().getString("worldfolder", "plugins/WorldSystem/Worlds") + "/";
    }

    public static boolean isMultiChoose() {
        return PluginConfig.getConfig().getBoolean("worldtemplates.multi_choose", false);
    }

    public static String getDefaultWorldTemplate() {
        return PluginConfig.getConfig().getString("worldtemplates.default", "");
    }

    public static String getLanguage() {
        return PluginConfig.getConfig().getString("language", "en");
    }

    public static String getPrefix() {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)PluginConfig.getConfig().getString("prefix", "\u00a78[\u00a73WorldSystem\u00a78] \u00a76"));
    }

    public static Location getWorldSpawn(World w) {
        return PluginConfig.getLocation(PluginConfig.getConfig(), "worldspawn.spawnpoint", w);
    }

    public static Location getSpawn(Player player) {
        YamlConfiguration cfg = PluginConfig.getConfig();
        Location location = PluginConfig.getLocation(cfg, "spawn.spawnpoint", Bukkit.getWorld((String)cfg.getString("spawn.spawnpoint.world", "world")));
        return PlayerPositions.instance.injectPlayersLocation(player, location);
    }

    public static int getRequestExpire() {
        return PluginConfig.getConfig().getInt("request_expires", 20);
    }

    private static Location getLocation(YamlConfiguration cfg, String path, World world) {
        return new Location(world, cfg.getDouble(path + ".x", 0.0), cfg.getDouble(path + ".y", 20.0), cfg.getDouble(path + ".z", 0.0), (float)cfg.getDouble(path + ".yaw", 0.0), (float)cfg.getDouble(path + ".pitch", 0.0));
    }

    public static boolean confirmNeed() {
        return PluginConfig.getConfig().getBoolean("need_confirm", true);
    }

    public static boolean contactAuth() {
        return PluginConfig.getConfig().getBoolean("contact_authserver", true);
    }

    public static boolean spawnTeleportation() {
        return PluginConfig.getConfig().getBoolean("spawn_teleportation", true);
    }

    public static boolean shouldDelete() {
        return PluginConfig.getConfig().getInt("delete_after") != -1;
    }

    public static long deleteAfter() {
        return PluginConfig.getConfig().getLong("delete_after");
    }

    public static boolean useWorldSpawnLastLocation() {
        return PluginConfig.getConfig().getBoolean("worldspawn.use_last_location");
    }

    public static boolean useSpawnLastLocation() {
        return PluginConfig.getConfig().getBoolean("spawn.spawnpoint.use_last_location");
    }

    public static String getWorldsTableName() {
        return PluginConfig.getConfig().getString("database.worlds_table_name");
    }

    public static String getPlayersTableName() {
        return PluginConfig.getConfig().getString("database.players_table_name");
    }

    public static String getUUIDTableName() {
        return PluginConfig.getConfig().getString("database.players_uuids");
    }

    public static String getDatabaseType() {
        return PluginConfig.getConfig().getString("database.type");
    }

    public static String getSqliteFile() {
        return PluginConfig.getConfig().getString("database.sqlite_settings.file");
    }

    public static String getMysqlHost() {
        return PluginConfig.getConfig().getString("database.mysql_settings.host");
    }

    public static int getMysqlPort() {
        return PluginConfig.getConfig().getInt("database.mysql_settings.port");
    }

    public static String getMysqlUser() {
        return PluginConfig.getConfig().getString("database.mysql_settings.username");
    }

    public static String getMysqlPassword() {
        return PluginConfig.getConfig().getString("database.mysql_settings.password");
    }

    public static String getMysqlDatabaseName() {
        return PluginConfig.getConfig().getString("database.mysql_settings.database");
    }

    public static boolean loadWorldsASync() {
        return PluginConfig.getConfig().getBoolean("load_worlds_async");
    }
}

