/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world.config;

import de.butzlabben.world.config.PluginConfig;
import de.butzlabben.world.util.PlayerWrapper;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class DependenceConfig {
    private UUID uuid;

    public DependenceConfig() {
        this.setConfig();
    }

    public DependenceConfig(String s) {
        OfflinePlayer op = null;
        try {
            op = PlayerWrapper.getOfflinePlayer(UUID.fromString(s));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (op == null) {
            op = PlayerWrapper.getOfflinePlayer(s);
        }
        this.uuid = op.getUniqueId();
    }

    public DependenceConfig(Player p) {
        this.uuid = p.getUniqueId();
        this.refreshName();
    }

    public DependenceConfig(OfflinePlayer p) {
        this.uuid = p.getUniqueId();
        this.refreshName();
    }

    public DependenceConfig(UUID uuid) {
        this.uuid = uuid;
    }

    public static int getHighestID() {
        File dconfig = new File("plugins//WorldSystem//dependence.yml");
        YamlConfiguration dcfg = YamlConfiguration.loadConfiguration((File)dconfig);
        return dcfg.getInt("HighestID");
    }

    public static void checkWorlds() {
        File dconfig = new File("plugins//WorldSystem//dependence.yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)dconfig);
        long deleteTime = 86400000L * PluginConfig.deleteAfter();
        long now = System.currentTimeMillis();
        for (String s : cfg.getConfigurationSection("Dependences").getKeys(false)) {
            long lastLoaded;
            long diff;
            if (!cfg.isLong("Dependences." + s + ".last_loaded") && !cfg.isInt("Dependences." + s + ".last_loaded") || (diff = now - (lastLoaded = cfg.getLong("Dependences." + s + ".last_loaded"))) <= deleteTime) continue;
            Bukkit.getConsoleSender().sendMessage(PluginConfig.getPrefix() + "World of " + s + " was not loaded for too long. Deleting!");
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("ws delete " + s));
        }
    }

    private void setConfig() {
        File dconfig = new File("plugins//WorldSystem//dependence.yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)dconfig);
        cfg.set("HighestID", (Object)-1);
        try {
            cfg.save(dconfig);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void refreshName() {
        if (this.hasWorld()) {
            File dconfig = new File("plugins//WorldSystem//dependence.yml");
            YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)dconfig);
            String uuid = this.uuid.toString();
            cfg.set("Dependences." + uuid + ".ActualName", (Object)PlayerWrapper.getOfflinePlayer(this.uuid).getName());
            try {
                cfg.save(dconfig);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void createNewEntry() {
        File dconfig = new File("plugins//WorldSystem//dependence.yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)dconfig);
        String uuid = this.uuid.toString();
        int id = cfg.getInt("HighestID");
        cfg.set("HighestID", (Object)(++id));
        cfg.set("Dependences." + uuid + ".ID", (Object)id);
        cfg.set("Dependences." + uuid + ".ActualName", (Object)PlayerWrapper.getOfflinePlayer(this.uuid).getName());
        try {
            cfg.save(dconfig);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean hasWorld() {
        File dconfig = new File("plugins//WorldSystem//dependence.yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)dconfig);
        String uuid = this.uuid.toString();
        return cfg.isInt("Dependences." + uuid + ".ID");
    }

    public String getWorldname() {
        File dconfig = new File("plugins//WorldSystem//dependence.yml");
        YamlConfiguration dcfg = YamlConfiguration.loadConfiguration((File)dconfig);
        String uuid = this.uuid.toString();
        int id = dcfg.getInt("Dependences." + uuid + ".ID");
        return "ID" + id + "-" + uuid;
    }

    public String getWorldNameByOfflinePlayer() {
        String uuid = this.uuid.toString();
        File dconfig = new File("plugins//WorldSystem//dependence.yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)dconfig);
        Object name = cfg.getString("Dependences." + uuid + ".ActualName") == null ? "n" : "ID" + cfg.getInt("Dependences." + uuid + ".ID") + "-" + uuid;
        return name;
    }

    public void setLastLoaded() {
        File dconfig = new File("plugins//WorldSystem//dependence.yml");
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)dconfig);
        String uuid = this.uuid.toString();
        cfg.set("Dependences." + uuid + ".last_loaded", (Object)System.currentTimeMillis());
        try {
            cfg.save(dconfig);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getID() {
        File dconfig = new File("plugins//WorldSystem//dependence.yml");
        YamlConfiguration dcfg = YamlConfiguration.loadConfiguration((File)dconfig);
        return dcfg.getInt("Dependences." + this.uuid.toString() + ".ID");
    }

    public OfflinePlayer getOwner() {
        return PlayerWrapper.getOfflinePlayer(this.uuid);
    }
}

