/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.world;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.util.UUIDTypeAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class GameProfileBuilder {
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).registerTypeAdapter(GameProfile.class, (Object)new GameProfileSerializer()).registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer()).create();
    private static final HashMap<UUID, CachedProfile> cache = new HashMap();
    private static final Object sync = new Object();
    private static long cacheTime = -1L;

    public static GameProfile fetch(UUID uuid) throws IOException {
        return GameProfileBuilder.fetch(uuid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GameProfile fetch(UUID uuid, boolean forceNew) throws IOException {
        HttpURLConnection connection;
        if (!forceNew && cache.containsKey(uuid) && cache.get(uuid).isValid()) {
            return GameProfileBuilder.cache.get((Object)uuid).profile;
        }
        Object object = sync;
        synchronized (object) {
            connection = (HttpURLConnection)new URL(String.format("https://sessionserver.mojang.com/session/minecraft/profile/%s?unsigned=false", UUIDTypeAdapter.fromUUID((UUID)uuid))).openConnection();
            connection.setReadTimeout(5000);
        }
        if (connection.getResponseCode() == 200) {
            String json = new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();
            GameProfile result = (GameProfile)gson.fromJson(json, GameProfile.class);
            cache.put(uuid, new CachedProfile(result));
            return result;
        }
        if (!forceNew && cache.containsKey(uuid)) {
            return GameProfileBuilder.cache.get((Object)uuid).profile;
        }
        throw new IOException("Could not connect to mojang servers for unknown player: " + uuid.toString());
    }

    public static GameProfile getProfile(UUID uuid, String name, String skin) {
        return GameProfileBuilder.getProfile(uuid, name, skin, null);
    }

    public static GameProfile getProfile(UUID uuid, String name, String skinUrl, String capeUrl) {
        GameProfile profile = new GameProfile(uuid, name);
        boolean cape = capeUrl != null && !capeUrl.isEmpty();
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(System.currentTimeMillis());
        args.add(UUIDTypeAdapter.fromUUID((UUID)uuid));
        args.add(name);
        args.add(skinUrl);
        if (cape) {
            args.add(capeUrl);
        }
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", Base64Coder.encodeString((String)String.format(cape ? "{\"timestamp\":%d,\"profileId\":\"%s\",\"profileName\":\"%s\",\"isPublic\":true,\"textures\":{\"SKIN\":{\"url\":\"%s\"},\"CAPE\":{\"url\":\"%s\"}}}" : "{\"timestamp\":%d,\"profileId\":\"%s\",\"profileName\":\"%s\",\"isPublic\":true,\"textures\":{\"SKIN\":{\"url\":\"%s\"}}}", args.toArray(new Object[0])))));
        return profile;
    }

    public static void setCacheTime(long time) {
        cacheTime = time;
    }

    private static class CachedProfile {
        private final GameProfile profile;

        public CachedProfile(GameProfile profile) {
            this.profile = profile;
        }

        public boolean isValid() {
            return cacheTime < 0L;
        }
    }

    private static class GameProfileSerializer
    implements JsonSerializer<GameProfile>,
    JsonDeserializer<GameProfile> {
        private GameProfileSerializer() {
        }

        public GameProfile deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = (JsonObject)json;
            UUID id = object.has("id") ? (UUID)context.deserialize(object.get("id"), UUID.class) : null;
            String name = object.has("name") ? object.getAsJsonPrimitive("name").getAsString() : null;
            GameProfile profile = new GameProfile(id, name);
            if (object.has("properties")) {
                for (Map.Entry prop : ((PropertyMap)context.deserialize(object.get("properties"), PropertyMap.class)).entries()) {
                    profile.getProperties().put((Object)((String)prop.getKey()), (Object)((Property)prop.getValue()));
                }
            }
            return profile;
        }

        public JsonElement serialize(GameProfile profile, Type type, JsonSerializationContext context) {
            JsonObject result = new JsonObject();
            if (profile.getId() != null) {
                result.add("id", context.serialize((Object)profile.getId()));
            }
            if (profile.getName() != null) {
                result.addProperty("name", profile.getName());
            }
            if (!profile.getProperties().isEmpty()) {
                result.add("properties", context.serialize((Object)profile.getProperties()));
            }
            return result;
        }
    }
}

