/*
 * Decompiled with CFR 0.152.
 */
package de.butzlabben.inventory;

import de.butzlabben.inventory.DependListener;
import de.butzlabben.inventory.OrcClickListener;
import de.butzlabben.inventory.OrcInventory;
import de.butzlabben.world.wrapper.WorldPlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class OrcItem {
    public static final OrcItem error = new OrcItem(Material.BARRIER, null, "\u00a7cERROR: Item is wrong configured!", "\u00a7cPath in config: see Displayname");
    public static OrcItem enabled;
    public static OrcItem disabled;
    public static OrcItem coming_soon;
    public static OrcItem back;
    public static OrcItem fill;
    private ItemStack is;
    private OrcClickListener listener;
    private DependListener depend;
    private Runnable callback;

    public OrcItem(Material mat, String display, String ... lore) {
        this.setItemStack(mat, display, lore);
    }

    public OrcItem(ItemStack is) {
        this.setItemStack(is);
    }

    public OrcItem(Material mat, String display, List<String> lore) {
        this.setItemStack(mat, (byte)0, display, lore);
    }

    public OrcItem(Material mat) {
        this(new ItemStack(mat));
    }

    public OrcItem(Material material, byte data, String display, ArrayList<String> lore) {
        this.setItemStack(material, data, display, lore);
    }

    public void setCallback(Runnable r) {
        this.callback = r;
    }

    public OrcItem setItemStack(Material mat, byte data, String display, List<String> lore) {
        this.is = new ItemStack(mat, 1, (short)data);
        ItemMeta meta = this.is.getItemMeta();
        meta.setDisplayName(display);
        meta.setLore(lore);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        this.is.setItemMeta(meta);
        return this;
    }

    public ItemStack getItemStack(Player p) {
        ItemStack is;
        if (p != null && this.depend != null && (is = this.depend.getItemStack(p, new WorldPlayer(p))) != null) {
            return is;
        }
        return this.is;
    }

    public ItemStack getItemStack(Player p, WorldPlayer wp) {
        ItemStack is;
        if (p != null && this.depend != null && (is = this.depend.getItemStack(p, wp)) != null) {
            return is;
        }
        return this.is;
    }

    public ItemStack getItemStack() {
        return this.is;
    }

    public OrcItem setItemStack(ItemStack is) {
        Objects.requireNonNull(is, "ItemStack cannot be null");
        this.is = is;
        ItemMeta meta = is.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        is.setItemMeta(meta);
        return this;
    }

    public OrcItem setOnClick(OrcClickListener listener) {
        this.listener = listener;
        return this;
    }

    public OrcItem onClick(Player p, OrcInventory inv) {
        if (this.listener != null) {
            this.listener.onClick(p, inv, this);
        }
        if (this.callback != null) {
            this.callback.run();
        }
        return this;
    }

    public OrcItem setDisplay(String display) {
        ItemMeta meta = this.is.getItemMeta();
        meta.setDisplayName(display);
        this.is.setItemMeta(meta);
        return this;
    }

    public OrcItem setLore(String ... lore) {
        ItemMeta meta = this.is.getItemMeta();
        meta.setLore(Arrays.asList(lore));
        this.is.setItemMeta(meta);
        return this;
    }

    public OrcItem removeLore() {
        ItemMeta meta = this.is.getItemMeta();
        meta.setLore(null);
        this.is.setItemMeta(meta);
        return this;
    }

    public OrcItem setItemStack(Material mat, String display, String ... lore) {
        return this.setItemStack(mat, (byte)0, display, Arrays.asList(lore));
    }

    public OrcItem setDepend(DependListener listener) {
        this.depend = listener;
        return this;
    }

    public OrcItem clone() {
        return new OrcItem(this.is);
    }
}

