from easyhid import Enumeration
import time

# Stores an enumeration of all the connected USB HID devices
en = Enumeration()

# return a list of devices based on the search parameters
devices = en.find(vid=0xFFFF, pid=0x2055)

# print a description of the devices found
for dev in devices:
    print(dev.description())

# open a device
dev.open()

# write some bytes to the device
#dev.write(bytearray([0, 1, 2, 3]))

cnt = 0
t = time.time()
while True:
    ret = dev.write([0x11, 0x22, 0x33, 0x44, 0x55, 0x66], report_id=0x55)
    dt = (time.time()-t)*1000
    print(f"{ret} - {cnt} - {dt:.3}ms")
    t = time.time()
    cnt +=1
	
# close a device
dev.close()
